import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.DriverManager;

public class PraparedStatementClient {
    
    public static void main(String args[]) throws Exception {
        
        Class.forName("org.postgresql.Driver");
        String url = "jdbc:postgresql:bpfinal";
        Connection con = 
            DriverManager.getConnection(url,"meeraj","password");
            
        PreparedStatement stmt;
        
        String insertSQL = "INSERT INTO customer(title,fname," +
            "lname,addressline,town,zipcode,phone) VALUES " +
            "(?,?,?,?,?,?,?)";
        
        stmt = con.prepareStatement(insertSQL);
                                
        System.out.println("Inserting records");
        
        stmt.setString(1,"Mr");
        stmt.setString(2,"Fred");
        stmt.setString(3,"Flinstone");
        stmt.setString(4,"31 Bramble Avenue");
        stmt.setString(5,"London");
        stmt.setString(6,"NT2 1AQ");
        stmt.setString(7,"023 9876");
        stmt.executeUpdate();
        
        stmt.clearParameters();
        
        stmt.setString(1,"Mr");
        stmt.setString(2,"Berney");
        stmt.setString(3,"Rubble");
        stmt.setString(4,"22 Ramsons Avenue");
        stmt.setString(5,"London");
        stmt.setString(6,"PWD LS1");
        stmt.setString(7,"111 2313");
        stmt.executeUpdate(); 
                   
        System.out.println("Records Inserted");
        System.out.println();
        
        System.out.println("Selecting records");
        String selectSQL = "SELECT * FROM customer";
        stmt = con.prepareStatement(selectSQL);
        ResultSet res = stmt.executeQuery();
        while(res.next()) {
		for(int i = 1;i <= res.getMetaData().getColumnCount();i++) {
			System.out.print(res.getString(i) + "\t");
		}
		System.out.println();
        }
        System.out.println();
        
        System.out.println("Deleting records");
        String deleteSQL = "DELETE FROM customer";
        stmt = con.prepareStatement(deleteSQL);
        System.out.println("Records deleted: " + 
            stmt.executeUpdate());
        
        res.close();
        
        stmt.close();
        con.close();
        
    }
    
}
