import javax.swing.JTextField;
import javax.swing.JPanel;
import javax.swing.JLabel;

import javax.swing.border.TitledBorder;
import javax.swing.border.EtchedBorder;

import java.awt.GridLayout;
import java.awt.FlowLayout;

public class CustomerPanel extends JPanel {

//Instantiate the input fields for entering the details for a new customer:

	private JTextField title = new JTextField(15);
	private JTextField fname = new JTextField(15);
	private JTextField lname = new JTextField(15);
	private JTextField addressLine = new JTextField(15);
	private JTextField town = new JTextField(15);
	private JTextField zipCode = new JTextField(15);
	private JTextField phone = new JTextField(15);	

//Instantiate and return a customer object using the values entered into the form fields by the user:

	public Customer getCustomer() {
		
		return new Customer(-1,title.getText(),
			fname.getText(),lname.getText(),
			addressLine.getText(),town.getText(),
			zipCode.getText(),phone.getText());
			
	}

//The constructor initializes the user interface for the form: 

	public CustomerPanel() {

//Sets the layout to a 7*1 grid:

		setLayout(new GridLayout(7,1));    

//Add the field for entering the title:

		JPanel panel1 = new JPanel();
		panel1.setLayout(new FlowLayout(FlowLayout.RIGHT));
		panel1.add(new JLabel("Title:"));
		panel1.add(title);
		add(panel1);

//Add the field for entering the first name:

		JPanel panel2 = new JPanel();
		panel2.setLayout(new FlowLayout(FlowLayout.RIGHT));
		panel2.add(new JLabel("First Name:"));
		panel2.add(fname);
		add(panel2);

//Add the field for entering the last name:

		JPanel panel3 = new JPanel();
		panel3.setLayout(new FlowLayout(FlowLayout.RIGHT));
		panel3.add(new JLabel("Last Name:"));
		panel3.add(lname);
		add(panel3);   

//Add the field for entering the address:

		JPanel panel4 = new JPanel();
		panel4.setLayout(new FlowLayout(FlowLayout.RIGHT));
		panel4.add(new JLabel("Address:"));
		panel4.add(addressLine);
		add(panel4);

//Add the field for entering the town:

		JPanel panel5 = new JPanel();
		panel5.setLayout(new FlowLayout(FlowLayout.RIGHT));
		panel5.add(new JLabel("Town:"));
		panel5.add(town);
		add(panel5);

//Add the field for entering the Zip code:

		JPanel panel6 = new JPanel();
		panel6.setLayout(new FlowLayout(FlowLayout.RIGHT));
		panel6.add(new JLabel("Zip Code:"));
		panel6.add(zipCode);
		add(panel6);

//Add the field for entering the phone number:

		JPanel panel7 = new JPanel();
		panel7.setLayout(new FlowLayout(FlowLayout.RIGHT));
		panel7.add(new JLabel("Phone:"));
		panel7.add(phone);
		add(panel7);
		
		setBorder(new TitledBorder(new EtchedBorder(),"Add Customer"));	
		
	}

//This method blanks out the form for entering customer information:

	public void reset() {
        
		title.setText("");
		fname.setText("");
		lname.setText("");
		addressLine.setText("");
		town.setText("");
		zipCode.setText("");
		phone.setText("");
	
	}
	
}
