select.pl
#!/usr/bin/perl -w

use Pg;
use strict;

# Function for non-query commands
sub doSQL
{
    my ($conn, $command) = @_;

    print $command, "\n";

    my $result = $conn->exec($command);
    print "status is ", $result->resultStatus, "\n";
    print "#rows affected ", $result->cmdTuples, "\n";
    print "result message: ", $conn->errorMessage, "\n";
}

# Function specifically for queries
sub doSQLquery
{
    my ($conn, $command) = @_;

    print $command, "\n";

    my $result = $conn->exec($command);
    print "status is ", $result->resultStatus, "\n";

    return if($result->resultStatus ne PGRES_TUPLES_OK);

    print "number of rows returned = ", $result->ntuples, "\n";
    print "number of fields returned = ", $result->nfields, "\n";

    print "fields: ";
    for(my $n = 0; $n < $result->nfields; ++$n) {
       print " ", $result->fname($n);
    }
    print "\n";

    while(my @row = $result->fetchrow) {
         print " ", join(" ", @row), "\n";
    }
}

my $conn = Pg::connectdb("") or die "connection failed";

doSQL($conn, "DROP TABLE number");
doSQL($conn, "CREATE TABLE number ( value INTEGER, name  VARCHAR )");
doSQL($conn, "INSERT INTO number values(42, 'The Answer')");
doSQL($conn, "INSERT INTO number values(29, 'My Age')");
doSQL($conn, "INSERT INTO number values(29, 'Anniversary')");
doSQL($conn, "INSERT INTO number values(66, 'Clickety-Click')");
doSQLquery($conn, "SELECT * FROM number WHERE value = 29");
doSQL($conn, "UPDATE number SET name = 'Zaphod' WHERE value = 42");
doSQL($conn, "DELETE FROM number WHERE value = 29");

