drop table reorders;
create table reorders 
( 
  item_id	integer,
  message	text
);

  create function reorders(int4) returns integer as '
declare
	min_stock alias for $1;
	reorder_item integer;
	reorder_count integer;
	stock_row stock%rowtype;
	msg text;
begin
	select count(*) into reorder_count from stock
	       where quantity <= min_stock;
	for stock_row in select * from stock 
			 where quantity <= min_stock
	loop
		declare
			item_row item%rowtype;
		begin
			select * into item_row from item
			       where item_id = stock_row.item_id;
			msg = ''order more '' || 
                         item_row.description || ''s at '' || 
                         to_char(item_row.cost_price,''99.99'');
			insert into reorders 
                         values (stock_row.item_id, msg);
		end;
	end loop;
	return reorder_count;
end;
' language 'plpgsql';
