create function customer_trigger() returns opaque AS' 
declare order_record record;
begin
	       select * into order_record from orderinfo
	       where customer_id = old.customer_id
	       and date_shipped = NULL;
	if not found
	then
	raise  notice ''deletion allowed  no outstanding orders'';

	  	for order_record in select * from orderinfo
		    where customer_id = old.customer_id
		loop
			delete from orderline 
			       where orderinfo_id = order_record.orderinfo_id;
		end loop;
		
			delete from orderinfo
		       where customer_id = old.customer_id;
		
			return old;
	else
			raise notice ''deletion aborted  outstanding orders present'';
		return NULL;
	end if;
end;
' language 'plpgsql';

create trigger trig_customer before delete on customer
for each row execute procedure customer_trigger();
