package com.wakaleo.bddinaction.chapter9.flightstatus.steps;

import com.wakaleo.bddinaction.chapter9.flightstatus.client.FlightStatusClient;
import com.wakaleo.bddinaction.chapter9.flightstatus.client.JerseyFlightStatusClient;
import com.wakaleo.bddinaction.chapter9.flightstatus.model.FlightType;
import cucumber.api.DataTable;
import cucumber.api.java.en.Given;
import cucumber.api.java.en.Then;
import cucumber.api.java.en.When;
import org.json.JSONException;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;

import java.util.List;

public class ScheduledFlightsSteps {

    String departure;
    List retrievedFlights;

    @Given("^zostały zaplanowane następujące loty:")
    public void setup_scheduled_flights(DataTable testData) {
        // Konfiguracja danych testowych
    }

    @Given("^chcę poznać szczegóły lotu numer (.*)$")
    public void I_want_to_check_the_flights_out_of(String departure) throws Throwable {
        this.departure = departure;
    }

    @When("^poproszę o informacje o lotach loty$")
    public void I_request_flights_of_type(FlightType flightType) throws Throwable {
        FlightStatusClient client = new JerseyFlightStatusClient();
        retrievedFlights = client.findByDepartureCityAndType(departure, flightType);
    }

    @When("^poproszę o informacje o lotach loty$ w formacie JSON")
    public void request_flights_of_type_in_json(FlightType flightType) throws Throwable {
        FlightStatusClient client = new JerseyFlightStatusClient();
        receivedJsonData = client.findByDepartureCityAndTypeInJson(departure, flightType);
    }

    @Then("powinienem otrzymać informacje o następujących lotach:$")
    public void I_should_see_the_following_flights(DataTable expectedFlights) throws Throwable {
        expectedFlights.diff(retrievedFlights);
    }

    protected String receivedJsonData;

    @Then("^powinienem otrzymać informacje o następujących lotach:$")
    public void should_receive_json_data(String expectedJsonData) throws JSONException {
        JSONAssert.assertEquals(expectedJsonData, receivedJsonData, JSONCompareMode.LENIENT);
    }
}

