package com.bddinaction.chapter5.jbehave.steps;

import org.jbehave.core.annotations.Given;
import org.jbehave.core.annotations.Pending;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;

public class EarningPointsSteps {

    @Given("odległość przelotu z $departure do $destination wynosi $distance km")
    @Pending
    public void defineTheFlyingDistanceForATrip(String departure,
                                                String destination,
                                                int distance) {
    }

    @Given("jestem uczestnikiem programu Frequent Flyer o statusie $status")
    @Pending
    public void defineAMemberWithStatus(String status) {
    }

    @When("lecę z $departure do $destination dnia $date o $time")
    public void whenIFlyFrom(String departure, String destination,
                             DateTime date, LocalTime time) {
    }

    @Then("powinienem zdobyć $points punktów")
    public void thenIShouldEarn(int points) {
    }

    @Given("chcę zostać uczestnikiem programu Frequent Flyer")
    @Pending
    public void givenThatIWantToBecomeAFrequentFlyer() {
    }

    @When("Zarejestruję się w programie Frequent Flyer")
    public void whenIRegisterForTheFrequentFlyerProgram() {
    }

    @Then("Wtedy powinienem otrzymać e-mail o następującej treści: $email")
    public void thenIShouldReceiveAnEmailLikeThis(String email) {
    }
    @Then("wszystko powinno działać")
    public void itShouldAllWork() {}

    @Given("jestem uczestnikiem o statusie $status")
    @Pending
    public void statusIs(String status) {
    }

    @When("podróżuję lotem, który jest wart <punkty_bazowe> punktów")
    public void flyFor(int base) {}

    @Then("powinienem zdobyć premię wynoszącą <premia> punktów")
    public void shouldEarnStatusBonus(int bonus) {}

    @Then("powinienem korzystać z gwarantowanego minimum zdobytych punktów za podróż w liczbie <minimum> punktów")
    public void shouldHaveGuaranteedMinimum(int minimum) {}


    @Then("powinienem zdobyć całkowitą liczbę <razem> punktów")
    public void shouldEarnTotalOf(int total) {}
}

