package com.bddinaction.chapter2.jbehave.steps;

import com.bddinaction.chapter2.services.InMemoryTimetableService;
import com.bddinaction.chapter2.services.ItineraryService;
import org.jbehave.core.annotations.Given;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;
import org.joda.time.LocalTime;

import java.util.List;

import static org.fest.assertions.Assertions.assertThat;

public class OptimalItinerarySteps {

    InMemoryTimetableService timetableService;

    @Given("pociągi linii $line z $lineStart odjeżdżają ze stacji $departure do $destination o $departureTimes")	
    public void givenArrivingTrains(String line,
                                    String lineStart,
                                    String departure,
                                    String destination,
                                    List<LocalTime> departureTimes) {
        timetableService = new InMemoryTimetableService();
    }

    List<LocalTime> proposedTrainTimes;

    @When("chcę podróżować z $departure do $destination o $startTime")
	public void whenIWantToTravel(String departure, String destination, LocalTime startTime) {
        ItineraryService itineraryService = new ItineraryService(timetableService);
        proposedTrainTimes = itineraryService.findNextDepartures(departure, destination, startTime);
    }

    @Then("powinienem uzyskać informację o pociągach o: $expectedTrainTimes")
    public void shouldBeInformedAbout(List<LocalTime> expectedTrainTimes) {
        assertThat(proposedTrainTimes).isEqualTo(expectedTrainTimes);
    }
}

