package com.bddinaction.chapter2.jbehave.steps;

import com.bddinaction.chapter2.services.InMemoryTimetableService;
import org.jbehave.core.annotations.Given;
import org.jbehave.core.annotations.Named;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;
import org.joda.time.LocalTime;

import static org.fest.assertions.Assertions.assertThat;


public class EstimatedArrivalTimeSteps {

    InMemoryTimetableService timetable = new InMemoryTimetableService();

    String departure;
    String destination;
    String travellingOnLine;

    @Given("chcę się dostać z <departure> do <destination>")
    public void givenIWantToGoFrom(String departure, String destination) {
        this.departure = departure;
        this.destination = destination;
    }

    @Given("następny pociąg odjeżdża o <czas-wyjazdu> na linii <line>")
    public void givenTheNextTrainIsScheduledToLeave(@Named("czas-wyjazdu") LocalTime departureTime,
                                                    String line) {
        timetable.scheduleArrivalTime(line, departureTime);
        travellingOnLine = line;
    }

    LocalTime arrivalTime;

    @When("zapytam o godzinę przyjazdu")
    public void whenIAskForMyArrivalTime() {
        arrivalTime = timetable.getArrivalTime(travellingOnLine, destination);
    }

    @Then("powinienem uzyskać następujący szacowany czas przyjazdu:<czas-przyjazdu>")
    public void thenTheEstimatedArrivalTimeShouldBe(@Named("czas-przyjazdu") LocalTime expectedArrivalTime) {
        // TODO: Usuń komentarz, aby rzeczywiście przetestować usługę back-end
        //assertThat(arrivalTime).isEqualTo(expectedArrivalTime);
    }
}

