package com.bddinaction.chapter12.model

import spock.lang.Specification

import static com.bddinaction.chapter12.model.FrequentFlyerStatus.*

class WhenManagingFrequentFlyerMemberStatusUpdates extends Specification {

    def "Uczestnik programu Frequent Flyer wymaga imienia, nazwiska i numeru uczestnika frequent flyer"() {
        when:
            def member = FrequentFlyer.withFrequentFlyerNumber("12345678").named("Janusz","Bloger")
        then:
            member.frequentFlyerNumber == "12345678"
        and:
            member.firstName == "Janusz"
        and:
            member.lastName == "Bloger"
    }

    def "nowy uczestnik programu frequent powinien mieć status Brązowy"() {
        given:
            def member = FrequentFlyer.withFrequentFlyerNumber("12345678").named("Janusz","Bloger")
        when:
            def status = member.status
        then:
            status == FrequentFlyerStatus.BRĄZOWY
    }


    def "powinien być w stanie zaktualizować status uczestnika programu Frequent Flyer"() {
        given:
            def member = FrequentFlyer.withFrequentFlyerNumber("12345678").named("Janusz","Bloger")
        when:
            def updatedMember = member.withStatus(FrequentFlyerStatus.SREBRNY)
        then:
            updatedMember.status == FrequentFlyerStatus.SREBRNY
    }

    def "uczestnik powinien mieć możliwość zdobycia dodatkowych punktów statusowych"() {
        given:
            def member = FrequentFlyer.withFrequentFlyerNumber("12345678").
                    named("Janusz","Bloger").
                    withStatusPoints(initialPoints)
        when:
            member.earns(additionalPoints).statusPoints()
        then:
            member.statusPoints == expectedPoints
        where:
            initialPoints | additionalPoints  | expectedPoints
            0             | 100               | 100
            100           | 50                | 150
    }

    def "powinien aktualizować status uczestnika po zdobyciu wystarczającej liczby punktów"() {
        given: "uczestnik programu frequent flyer z określoną liczbą punktów"
            def member = FrequentFlyer.withFrequentFlyerNumber("12345678").
                    named("Janusz","Bloger").
                    withStatusPoints(initialPoints).
                    withStatus(initialStatus)
        when: "zdobędzie dodatkowe punkty za lot"
            member.earns(extraPoints).statusPoints()
        then: "może uaktualnić swój status do nowego poziomu"
            member.getStatus() == expectedStatus
        where:
            initialStatus | initialPoints | extraPoints | expectedStatus
            BRĄZOWY       | 0             | 299         | BRĄZOWY
            BRĄZOWY       | 0             | 300         | SREBRNY
            SREBRNY       | 0             | 699         | SREBRNY
            SREBRNY       | 0             | 700         | ZŁOTY
            ZŁOTY         | 0             | 1499        | ZŁOTY
            ZŁOTY         | 0             | 1500        | PLATYNOWY
    }

}

