#!/usr/bin/bash

siedzenia=()
function rezerwuj {
    miejsce=$(($1 - 1))
    dane=$2
    if [[ -z ${siedzenia[$miejsce]} ]]
    then
        siedzenia[miejsce]=$dane
        echo "Zarezerwowano miejsce $1 dla $dane"
    else
        echo "Miejsce jest już zajęte!"
    fi
}

function zwolnijRezerwacje {
    miejsce=$(($1 - 1))
    if [[ -n ${siedzenia[$miejsce]} ]]
    then
        siedzenia[miejsce]=""
        echo "Zwolniono rezerwację"
    else
        echo "Miejsce jest obecnie puste"
    fi
}

function wyswietlStanSali {
    echo "\r"
    for ((i=0; $i<$iloscSiedzen; i++))
    do
        if [[ -n ${siedzenia[$i]} ]]
        then
            echo -n "[X] "
        else
            echo -n "[ ] "
        fi
        if (( ($i + 1) % 5 == 0 ))
        then
            echo "\n"
        fi
    done
}

function wyswietlStanSiedzenia {
    miejsce=$(($1 - 1))
    if [[ -z ${siedzenia[$miejsce]} ]]
    then
        echo "Miejsce $1 jest puste"
    else
        echo "Miejsce $1: ${siedzenia[$miejsce]}"
    fi
}