#!/usr/bin/bash

declare -A siedzenia=()

function pobierzKlucz {
    local numerSali=$1
    local siedzenie=$2
    echo $numerSali"_"$siedzenie
}

function rezerwuj {
    local miejsce=$(($1 - 1))
    local numerSali=$2
    local dane=$3
    local klucz=$(pobierzKlucz $numerSali $miejsce)
    if [[ -z ${siedzenia[$klucz]} ]]
    then
        siedzenia[$klucz]=$dane
        echo "Zarezerwowano miejsce $1 dla $dane"
    else
        echo "Miejsce jest już zajęte!"
    fi
}

function zwolnijRezerwacje {
    local miejsce=$(($1 - 1))
    local numerSali=$2
    local klucz=$(pobierzKlucz $numerSali $miejsce)
    if [[ -n ${siedzenia[$klucz]} ]]
    then
        siedzenia[klucz]=""
        echo "Zwolniono rezerwację"
    else
        echo "Miejsce jest obecnie puste"
    fi
}

function wyswietlStanSali {
    echo "\r"
    local numerSali=$1
    for ((i=0; $i<${iloscSiedzen[$numerSali]}; i++))
    do
        local klucz=$(pobierzKlucz $numerSali $i)
        if [[ -n ${siedzenia[$klucz]} ]]
        then
            echo -n "[X] "
        else
            echo -n "[ ] "
        fi
        if (( ($i + 1) % 5 == 0 ))
        then
            echo "\n"
        fi
    done
}

function wyswietlStanSiedzenia {
    local miejsce=$(($1 - 1))
    local numerSali=$2
    local klucz=$(pobierzKlucz $numerSali $miejsce)
    if [[ -z ${siedzenia[$klucz]} ]]
    then
        echo "Miejsce $1 jest puste"
    else
        echo "Miejsce $1: ${siedzenia[$klucz]}"
    fi
}