/*
 * Menu_GFX.c
 *
 * Created: 2013-11-18 21:24:00
 *  Author: tmf
 */

#include "Menu-GFX.h"
#include "ST7565/ST7565.h"
#include <stddef.h>
#include <string.h>
#include <avr\pgmspace.h>

static const __flash struct _menuitem_gfx *currMenuGFXPtr=&menu_gfx;   //Bieca pozycja menu
static int8_t menGFXuindex;                                    //Numer aktualnie wybrane pozycji menu
static int8_t menuGFXfirstpos;                                 //Numer pozycji menu wywietlanej w grnym rzdzie

uint8_t MenuGFX_GetMenuItemsNo()            //Policz ile dane menu ma pozycji
{
	const __flash struct _menuitem_gfx *tmpmenuitem=currMenuGFXPtr;
	uint8_t index=0;

	while(tmpmenuitem)
	{
		tmpmenuitem=tmpmenuitem->next;
		index++;
	}
	return index;
}

const __flash struct _menuitem_gfx *MenuGFX_GetMenuItem(uint8_t index)
{
	const __flash struct _menuitem_gfx *tmpmenuitem=currMenuGFXPtr;

	while((tmpmenuitem) && (index>0))
	{
		tmpmenuitem=tmpmenuitem->next;
		index--;
	}
	return tmpmenuitem;
}

uint8_t MenuGFX_GetMenuRows()
{
	return ST7565R_HEIGHT / (menu_gfx.gfx[1] + Menu_YBorder); //Wysoko bitmapy
}

uint8_t MenuGFX_GetMenuCols()
{
	return ST7565R_WIDTH / (menu_gfx.gfx[0] + Menu_XBorder);  //Szeroko bitmapy
}

void MenuGFX_Show()
{
	const __flash struct _menuitem_gfx *tmpmenuitem=MenuGFX_GetMenuItem(menuGFXfirstpos);
	uint8_t bmp_height=menu_gfx.gfx[1];
	uint8_t bmp_width=menu_gfx.gfx[0];
	uint8_t menuitemsno=MenuGFX_GetMenuItemsNo();
	uint8_t currmenupos=0;

	st7565r_Clear(false); //Wyczy LCD

	uint8_t xspacing=(ST7565R_WIDTH - MenuGFX_GetMenuCols() * (bmp_width + Menu_XBorder)) / (MenuGFX_GetMenuCols() + 1);
	uint8_t yspacing=(ST7565R_HEIGHT - MenuGFX_GetMenuRows() * (bmp_height + Menu_YBorder)) / (MenuGFX_GetMenuRows() + 1);

	for(uint8_t oy=0; oy < MenuGFX_GetMenuRows(); oy++)
	{
		for(uint8_t ox=0; ox < MenuGFX_GetMenuCols(); ox++)
		{
			if(tmpmenuitem == NULL) break;           //Nie ma wice pozycji menu - koczymy ptl
			uint8_t tx=ox * (bmp_width + Menu_XBorder) + (ox + 1) * xspacing + Menu_XBorder/2;
			uint8_t ty=oy * (bmp_height + Menu_YBorder) + (oy + 1) * yspacing + Menu_YBorder/2;
			if(menGFXuindex == ((menuGFXfirstpos + currmenupos) % menuitemsno))              //Czy podwietli dan pozycje menu?
			{
				st7565r_MoveTo(tx-2, ty-2); st7565r_LineTo(tx+bmp_width+2, ty-2, true); //_
				st7565r_LineTo(tx+bmp_width+2, ty+bmp_height+2, true);                  // |
				st7565r_LineTo(tx-2, ty+bmp_height+2, true);                            //_
				st7565r_LineTo(tx-2, ty-2, true);                                       //|
			}
			st7565r_draw_bitmap_mono(tx, ty, tmpmenuitem->gfx, false);     //Wywietl pozycj menu
			tmpmenuitem=tmpmenuitem->next;   //Kolejna pozycja menu
			currmenupos++;
		}
	}
	st7565r_CpyDirtyPages();   //Odwie widok na LCD
}

void MenuGFX_SelectNext()
{
	menGFXuindex=(menGFXuindex + 1) % MenuGFX_GetMenuItemsNo();     //Liczymy wszysko modulo liczba pozycji w menu
	menuGFXfirstpos=MenuGFX_GetMenuRows() * MenuGFX_GetMenuCols() * (menGFXuindex / (MenuGFX_GetMenuRows() * MenuGFX_GetMenuCols()));
	MenuGFX_Show();      //Wywietl menu
}

void MenuGFX_SelectPrev()
{
	if(menGFXuindex > 0) menGFXuindex--; else menGFXuindex=MenuGFX_GetMenuItemsNo()-1;
	menuGFXfirstpos=MenuGFX_GetMenuRows() * MenuGFX_GetMenuCols() * (menGFXuindex / (MenuGFX_GetMenuRows() * MenuGFX_GetMenuCols()));
	MenuGFX_Show();     //Wywietl menu
}

void MenuGFX_Back()
{
	menuGFXfirstpos=0;
	menGFXuindex=0;
	currMenuGFXPtr=currMenuGFXPtr->parent;
}

void MenuGFX_Click()
{
	const __flash struct _menuitem_gfx *tmpmenuitem=MenuGFX_GetMenuItem(menGFXuindex);
	const __flash struct _menuitem_gfx *submenu=tmpmenuitem->submenu;

	menugfxitemfuncptr mfptr=tmpmenuitem->menuitemfunc;
	if(mfptr) (*mfptr)(tmpmenuitem);
	if(submenu)
	{
		currMenuGFXPtr=submenu;
		menGFXuindex=0;
		menuGFXfirstpos=0;
	}
	MenuGFX_Show();
}