/*
 * PWM8_IRQ.c
 *
 * Created: 2013-10-01 20:07:34
 *  Author: tmf
 */


#include <stdbool.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <util/delay.h>

#define GET_FAR_ADDRESS(var)                  \
({                                            \
	__uint24 tmp;                             \
	__asm__ __volatile__(                     \
	"ldi	%A0, lo8(%1)"           "\n\t"    \
	"ldi	%B0, hi8(%1)"           "\n\t"    \
	"ldi	%C0, hh8(%1)"           "\n\t"    \
	: "=d" (tmp) :	"p"  (&(var)));           \
	tmp;                                      \
})

#define BUFFER_SIZE  512     //Wielko tymczasowego bufora na prbki (uyta jest dwukrotnie wiksza)

extern __memx const uint8_t _binary____intro8kHz8PWMHL_raw_end;
extern const __uint24 _binary____intro8kHz8PWMHL_raw_size;
extern __memx const uint8_t _binary____intro8kHz8PWMHL_raw_start;

#define Snd_NoPlaying      0        //Nic nie jest odgrywane
#define Snd_Playing8Bit    1        //Odtwarzamy 8-bitowe prbki

__uint24 srcaddr;                   //Adres prbek dwikowych
__uint24 samplesize;                //Dugo odtwarzanej prbki w bajtach
volatile uint8_t isPlaying;         //Stan odtwarzacza

bool OSC_wait_for_rdy(uint8_t clk)
{
	uint8_t czas=255;
	while ((!(OSC.STATUS & clk)) && (--czas)) // Czekaj na ustabilizowanie si generatora
	_delay_ms(1);
	return czas;   //false jeli generator nie wystartowa, true jeli jest ok
}

bool RC32M_en()
{
	OSC.CTRL |= OSC_RC32MEN_bm; //Wcz generator RC 32 MHz
	if(OSC_wait_for_rdy(OSC_RC32MEN_bm)) //Zaczekaj na jego poprawny start
	{
		CPU_CCP=CCP_IOREG_gc;
		CLK_CTRL=CLK_SCLKSEL_RC32M_gc;   //Wybierz zegar 32 MHz
		return true;
	}
	return false;
}

ISR(TCF0_OVF_vect)
{
	TCF0_CCABUF=pgm_read_byte_far(srcaddr++);
	samplesize--;
	if(samplesize == 0)
	{
		isPlaying=Snd_NoPlaying;
		TCF0_CTRLA=TC_CLKSEL_OFF_gc;  //Koniec odtwarzania dwikw
	}
}

void Snd_init(__uint24 smpaddr, __uint24 smpsize, uint16_t bitrate, _Bool HiRes)
{
	void Timer_init(uint16_t samplerate)  //Generuje zdarzenia wywoujce konwersj DAC i przeczanie buforw
	{
		PORTF_DIRSET=PIN0_bm;      //Wyjcie CCA
		TCF0.PER=0xff;
		TCF0.CTRLB=TC_WGMODE_SS_gc | TC0_CCAEN_bm;
		TCF0.CTRLA=TC_CLKSEL_EVCH0_gc;
		TCF0.INTCTRLA=TC_OVFINTLVL_LO_gc;  //Przerwanie nadmiaru timera

		//TCC0 - okrela samplerate
		TCC0.PER=F_CPU/(samplerate*256UL); //Wygeneruj zdarzenia o odpowiedniej czstotliwoci
		TCC0.CTRLB=TC_WGMODE_NORMAL_gc;  //Tryb normalny
		TCC0.CTRLA=TC_CLKSEL_DIV1_gc;
		EVSYS_CH0MUX=EVSYS_CHMUX_TCC0_OVF_gc; //taktowanie evch0 z przepenienia timera C0
	}

	samplesize=smpsize;           //Dugo odtwarzanej prbki w bajtach
	srcaddr=smpaddr;              //Adres prbki
	TCF0_CCA=pgm_read_byte_far(srcaddr++);     //ZAinicjuj odtwarzanie prbek
	TCF0_CCABUF=pgm_read_byte_far(srcaddr++);

	Timer_init(bitrate);          //Zainicjuj timer z odpowiednim samplerate
	isPlaying=Snd_Playing8Bit;
}

int main(void)
{
	RC32M_en();                 //Wcz generator RC 32 MHz
	isPlaying=Snd_NoPlaying;
	PMIC_CTRL=PMIC_LOLVLEN_bm;  //Odblokuj przerwania najniszego poziomu
	sei();

	PORTD_PIN0CTRL=PORT_OPC_PULLUP_gc; //Wczamy pullup na SW0

	while(1)
	{
		if(((PORTD_IN & PIN0_bm) == 0) && (isPlaying == Snd_NoPlaying)) Snd_init(GET_FAR_ADDRESS(_binary____intro8kHz8PWMHL_raw_start), GET_FAR_ADDRESS(_binary____intro8kHz8PWMHL_raw_size), 8000, false);  //Zagraj prbk 8kHz/8 bitw
	}
}