#ifndef _MENU_H
#define _MENU_H

#include <stdbool.h> 
#include <stdint.h>
#include <avr\pgmspace.h>

typedef void (*menuitemfuncptr)();

struct PROGMEM _menuitem 
{
	const char *text;
	menuitemfuncptr menuitemfunc;
	const struct _menuitem *parent;
	const struct _menuitem *submenu;
	const struct _menuitem *next;
};

void Menu_Show();
void Menu_SelectNext();
void Menu_SelectPrev();
void Menu_Click();
void Menu_Back();

extern const struct _menuitem PROGMEM menu;

#endif
