/*
 * Termostat.c
 *
 * Created: 2012-04-26 20:57:41
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <avr/interrupt.h>

ISR(ACA_AC0_vect)
{
	if(ACA_STATUS & AC_AC0STATE_bm) PORTE_OUT=0; else PORTE_OUT=0xFF;
}

void Comp_init()
{
	ACA.AC0MUXCTRL=AC_MUXPOS_PIN4_gc | AC_MUXNEG_PIN5_gc; //Wejcie + na pinie 4, wejcie - na pinie 5
	ACA.CTRLA=AC_AC0OUT_bm; //Udostpnij wyjcie komparatora na PA7
	ACA.AC0CTRL=AC_ENABLE_bm | AC_INTMODE_BOTHEDGES_gc | AC_INTLVL_LO_gc;  //Wcz komparator i przerwania
	//ACA.AC0CTRL|=AC_HYSMODE_SMALL_gc;  //Opcjonalnie wcz histerez
}

void LED_init()
{
	PORTE_DIR=0xFF;   //Port sterujcy LEDami jako wyjcie
}

int main(void)
{
	Comp_init();
	LED_init();	
	
	PMIC_CTRL=PMIC_LOLVLEN_bm; //Odblokuj przerwania niskiego poziomu
	sei();
	
    while(1);
}