#!/usr/bin/perl

$length = 0;
$receive = -1;
$newaddr = -1;

if ($#ARGV >= 0) {
    $name = shift(@ARGV);
}

open(IN, "vsomd $name |") || die;
while(<IN>) {
    $in = $_;
    while ($in =~ /^(.*)\\\s*$/) {
	$in = $1 . <IN>;
    }
    if ($in =~ /^\s+\.sect code,.+$/) {
	$receive = 0x8000;
    }
    if ($in =~ /^\s+\.sect data_y,.+$/) {
	$receive = 0x4000;
    }
    if ($in =~ /^\s+\.sect data_x,.+$/) {
	$receive = 0x0;
    }
    if ($in =~ /^\s+\.org\s+0x(\S+)\s*$/) {
	$newaddr = $1;
	$length = 0;
	print STDERR "newaddr $newaddr\n";
    }
    if ($in =~ /^(0x\S\S\S\S)\s+0x(\S\S\S\S)(\S\S\S\S).*$/) {
	if ($newaddr >= 0) {
	    printf STDERR "new I addr = $newaddr\n";
	    printf "W 2 7 %x\n", hex($newaddr)+$receive;
	    $newaddr=-1;
	}
#	printf "W 2 7 %x\n", hex($newaddr)+$receive+$length;

	printf "W 2 6 $2\n";
	printf "W 2 6 $3\n";
	$length++;
    } elsif ($in =~ /^(0x\S\S\S\S)\s+\.word\s+0x(\S\S\S\S).*$/) {
	if ($newaddr >= 0) {
	    printf STDERR "new X/Y addr = $newaddr\n";
	    printf "W 2 7 %x\n", hex($newaddr)+$receive;
	    $newaddr=-1;
	}

	printf "W 2 6 $2\n";
	$length++;
    }
}
close(IN);
$pos = $pos * 2;
printf STDERR "Total %d 32-bit words = %d bytes\n", $length, $length*4;

