#ifndef _GRAPHICS_H
#define _GRAPHICS_H

#include <stdint.h>

#define VIDEO_ACTIVE_PIXEL_START   2             //Pocztek widocznego obszaru linii
#define VIDEO_ACTIVELINE_START    60             //Pierwsza wywietlana linia
#define VIDEO_ACTIVELINE_END     260             //Ostatnia wywietlana linia

#define VIDEO_COLUMNS       (320/8)              //Dugo linii w bajtach (1 bajt - 8 pikseli)
#define VIDEO_LINES         (VIDEO_ACTIVELINE_END - VIDEO_ACTIVELINE_START)    //Liczba linii tekstu, liczba linii wywietlanych przez wysoko znaku

extern uint8_t framebuf[VIDEO_LINES*VIDEO_COLUMNS];     //Bufor ekranu

void GLCD_SetPixel(uint16_t x, uint16_t y);
void GLCD_Circle(uint16_t cx, uint16_t cy ,uint16_t radius);
void GLCD_Line(uint16_t x0, uint16_t y0, uint16_t x1, uint16_t y1);

#endif
