/*
 * RIFFHeader.h
 *
 * Created: 2013-11-21 16:48:51
 *  Author: tmf
 */


#ifndef RIFFHEADER_H_
#define RIFFHEADER_H_

#include <stdint.h>

typedef struct 
{
	char ChunkID[4];                  //Nagwek "RIFF"
	uint32_t ChunkSize;               //Wielko pliku - 8
	char Format[4];                   //Format pliku "WAVE"
	char SubChunk1ID[4];              //Format pola "fmt "
	uint32_t SubChunk1Size;           //Wielko pola 20 bajtw
	uint16_t AudioFormat;             //Kod formatu danych, np. 0x11 0x0 dla IMA ADPCM
	uint16_t NumOfChannels;           //Liczba kanaw - 0 dla mono
	uint32_t SampleRate;              //Prbkowanie [Hz]
	uint32_t ByteRate;                //Liczba bajtw na sekund
	uint16_t BlockAlign;              //Wyrwnanie bloku 0x100
	uint16_t BitsPerSample;           //Liczba bitw na prbk, np. 0x4 dla ADPCM
	uint16_t ByteExtraData;           //0x2 0x0
	uint16_t ExtraData;               //0xf9 0x1
	char SubChunk2ID[4];              //ID podpola "fact"
	uint32_t SubChunk2Size;           //Wielko podpola 4 bajty
	uint32_t NumOfSamples;            //Liczba prbek
	char SubChunk3ID[4];              //ID pola danych "data"
	uint32_t SubChunk3Size;           //Wielko pola danych
	uint8_t  Data[];                  //Dane prbek
} RIFFHeader_t;

extern const __flash uint8_t IMAADPCM_Header[60];   //Wzorcowy nagwek pliku w formacie IMA-ADPCM

#endif /* RIFFHEADER_H_ */