#ifndef _PINMACROS_H_
#define _PINMACROS_H_

/* single-bit macros, used for control bits */
#define JOIN(what, p) PORT##p##_##what
#define SET_(what, p, m) JOIN(what, p) |= (1 << (m))
#define SET(what, x) SET_(what, x)

#define CLR_(what, p, m) JOIN(what, p) &= ~(1 << (m))
#define CLR(what, x) CLR_(what, x)

#define GET_(p, m) JOIN(IN, p) & (1 << (m))
#define GET(x) GET_(x)

/* nibble macros, used for data path */
#define ASSIGN_(what, p, m, v) JOIN(what, p) = (JOIN(what, p) & \
~((1 << (m)) | (1 << ((m) + 1)) | \
(1 << ((m) + 2)) | (1 << ((m) + 3)))) | \
((v) << (m))
#define READ_(what, p, m) (JOIN(what, p) & ((1 << (m)) | (1 << ((m) + 1)) | \
(1 << ((m) + 2)) | (1 << ((m) + 3)))) >> (m)
#define ASSIGN(what, x, v) ASSIGN_(what, x, v)
#define READ(what, x) READ_(what, x)

#endif