/*
 * Optymalizacja.c
 *
 * Created: 2013-08-19 07:31:25
 *  Author: tmf
 */


#include <avr/io.h>
#include "SPI/SPI.h"
#include "st7565/ST7565.h"
#include <stdbool.h>
#include <avr/pgmspace.h>

void LCD_BackLight_Init()
{
	PORTE_DIRSET=PIN4_bm;     //Pin sterujcy bramk MOSFETa
	TCE1.CTRLB=TC1_CCAEN_bm | TC_WGMODE_SINGLESLOPE_gc;  //Tryb SS, CCA odblokowane
	TCE1.CCA=0x0080;          //Wypenienie 50%
	TCE1.PER=0x00ff;
	TCE1.CTRLA=TC_CLKSEL_DIV1_gc;
}

void LCD_BackLight_Set(uint8_t intensity)
{
	TCE1_CCA=intensity;
}

void LCD_Init()
{
	PORTA.OUTSET=PIN3_bm;     //Pin RESET
	PORTA.DIRSET=PIN3_bm;
	PORTD_DIRSET=PIN0_bm;     //Pin A0 - wybr dane/polecenie
	PORTF.OUTSET=PIN3_bm;
	PORTF.DIRSET=PIN3_bm;     //Sygna CS kontrolera
	st7565r_init();           //Zainicjuj kontroler
}

extern const __flash uint8_t* const __flash system16_array[];
extern const __flash uint8_t* const __flash system12_array[];
extern const __flash uint8_t* const __flash system8_array[];

int main(void)
{
	LCD_BackLight_Init();
	SPI_init();

	PORTF.OUTSET=PIN4_bm;    //Sygna CS pamici DataFLASH na pytce Xplained
	PORTF.DIRSET=PIN4_bm;
	//	PORTC.OUTSET=PIN2_bm | PIN3_bm | PIN4_bm; //Jeli mamy podczon pytk z TP, Flash i zczem SD na pokadzie
	//	PORTC.DIRSET=PIN2_bm | PIN3_bm | PIN4_bm;

	LCD_Init();
	st7565r_Clear(false);
	st7565r_SetText(0, 0, PSTR("Hello World !!!"), system8_array);
	st7565r_SetText(0, 8, PSTR("Hello World !!!"), system12_array);
	st7565r_SetText(0, 20, PSTR("Hello World !!!"), system16_array);
	st7565r_CpyDirtyPages();
	while(1);
}