/*
 * DataFLASHIO.c
 *
 * Created: 2013-06-27 19:58:49
 *  Author: tmf
 */

#include "diskio.h"
#include <stdbool.h>
#include <string.h>
#include "AT45CMD.h"                    //Dodaj polecenia pamici DataFLASH
#include "DataFLASH.h"                  //Dodaj transakcyjn obsuge pamici

static _Bool DataFLASHInitialized=false;      //Czy pami i interfejs SPI zostay zainicjowane?

/*-----------------------------------------------------------------------*/
/* Inidialize a Drive                                                    */
/*-----------------------------------------------------------------------*/

DSTATUS disk_initialize (
BYTE pdrv				/* Physical drive nmuber (0..) */
)
{
	DSTATUS ret=0xff;  //Wszystkie moliwe bdy
	uint8_t bufor[sizeof(SPI_Transact) + 4];
	SPI_Transact *trans=(SPI_Transact*)&bufor;
	uint8_t dato;
	dato=DataFlash_AddTransaction(AT45DBX_CMDC_RD_STATUS_REG, 0, 0, bufor, 1, true);  //Odczytaj rejestr stanu pamici
	if(trans->data[dato] & 0x80)
	{
		DataFLASHInitialized=true;
		ret=0; //Wszystko jest ok
	};
	return ret;    //Wszystko zostao zainicjowane i mamy dostp do pamici
}

/*-----------------------------------------------------------------------*/
/* Get Disk Status                                                       */
/*-----------------------------------------------------------------------*/

DSTATUS disk_status (
BYTE pdrv		/* Physical drive nmuber (0..) */
)
{
	if(DataFLASHInitialized==false) return STA_NOINIT;
	if(pdrv!=0) return STA_NODISK;
	return 0;  //Wszystko ok
}

/*-----------------------------------------------------------------------*/
/* Read Sector(s)                                                        */
/*-----------------------------------------------------------------------*/

DRESULT disk_read (
BYTE pdrv,		/* Physical drive nmuber (0..) */
BYTE *buff,		/* Data buffer to store read data */
DWORD sector,	/* Sector address (LBA) */
BYTE count		/* Number of sectors to read (1..128) */
)
{
	if(DataFLASHInitialized==false) return RES_NOTRDY;    //Pami niezainicjowana
	if(pdrv!=0) return RES_PARERR;  //Bdny identyfikator pamici

	uint8_t bufor[sizeof(SPI_Transact) + 4 + 512];  //Miejsce na bufor transakcji + wielko sektora
	SPI_Transact *trans=(SPI_Transact*)&bufor;

	while(count)
	{
		uint8_t dato=DataFlash_AddTransaction(AT45DBX_CMDA_RD_ARRAY_LF_SM, (sector / 2) * DataFLASH_PageSize + (sector & 1) * 512, bufor, 512, true); //Odczytaj dane z pamici
		memcpy(buff, &trans->data[dato], 512);        //Skopiuj dane z bufora transakcji

		buff+=512;  //Przesu si w buforze
		sector++;   //Odczytujemy kolejny sektor
		--count;
	}

	return RES_OK;
}

/*-----------------------------------------------------------------------*/
/* Write Sector(s)                                                       */
/*-----------------------------------------------------------------------*/

#if _USE_WRITE
DRESULT disk_write (
BYTE pdrv,			/* Physical drive nmuber (0..) */
const BYTE *buff,	/* Data to be written */
DWORD sector,		/* Sector address (LBA) */
BYTE count			/* Number of sectors to write (1..128) */
)
{
	if(DataFLASHInitialized==false) return RES_NOTRDY;    //Pami niezainicjowana
	if(pdrv!=0) return RES_PARERR;  //Bdny identyfikator pamici

	uint8_t bufor[sizeof(SPI_Transact) + 4 + 512];  //Miejsce na bufor transakcji + wielko sektora
	SPI_Transact *trans=(SPI_Transact*)&bufor;

	while(count)
	{
		DataFlash_AddTransaction(AT45DBX_CMDB_XFR_PAGE_TO_BUF1, (sector / 2) * DataFLASH_PageSize, bufor, 0, false); //Przepisz dane z pamici do bufora 1 DataFLASH
		memcpy(&trans->data[4], buff, 512);        //Skopiuj dane do bufora transakcji
		while(SPI_IsTransCompleted(trans)==false); //Zaczekaj na zakoczenie transakcji
		DataFLASH_WaitForReady();                  //Zaczekaj na gotowo pamici
		DataFlash_AddTransaction(AT45DBX_CMDC_WR_BUF1, (sector & 1) * 512, bufor, 512, true); //Zapisz dane do bufora 1 DataFLASH
		DataFlash_AddTransaction(AT45DBX_CMDB_PR_BUF1_TO_PAGE_ER, (sector / 2) * DataFLASH_PageSize, bufor, 0, true); //Zapisz dane z bufora 1 do DataFLASH
		DataFLASH_WaitForReady();   //Zaczekaj na koniec zapisu

		buff+=512;  //Przesu si w buforze
		sector++;   //Odczytujemy kolejny sektor
		--count;
	}

	return RES_OK;
}
#endif

#if _USE_IOCTL
DRESULT disk_ioctl (
BYTE pdrv,		/* Physical drive nmuber (0..) */
BYTE cmd,		/* Control code */
void *buff		/* Buffer to send/receive control data */
)
{
	if(DataFLASHInitialized==false) return RES_NOTRDY;    //Pami niezainicjowana

	DRESULT res=RES_OK;

	switch(cmd)
	{
		case GET_SECTOR_SIZE:   *((DWORD*)buff)=512;         //Dugo sektora 512 bajtw
		                        break;
		case GET_SECTOR_COUNT:  *((DWORD*)buff)=16384;       //Mamy 8 MB, czy 16384 sektorw po 512 bajtw
		                        break;
		case GET_BLOCK_SIZE:    *((DWORD*)buff)=1;           //Ile mona na raz skasowa sektorw
		                        break;
		case CTRL_SYNC:         break;
		case CTRL_ERASE_SECTOR: break;
		default:                res=RES_PARERR;        //Nieznane polecenie
	}

	return res;
}
#endif

#if _USE_WRITE

DWORD get_fattime (void)
{
	return 0;  //Bdnie, naley tu zwrci poprawn dat
}

#endif