/*
 * SDRAM1.c
 *
 * Created: 2012-04-16 22:05:33
 *  Author: tmf
 */ 

#define F_CLKPER2    2000000UL    //Zegar PCLKPER2

#include <avr/io.h>

void SDRAM_init()
{
	PORTH_DIR=0xFF;  //Sygnay sterujce
	PORTH_OUT=0x0F;  //Sygnay DQM, RAS, CAS i WE s nieaktywne w stanie 1
	PORTK_DIR=0xFF;  //Linie adresowe A0-A7
	PORTJ_DIR=0xF0;  //Linie A8-A11, modsza tetrada to linie danych D0-D3 - bez znaczenia

	EBI.SDRAMCTRLA=EBI_SDROW_bm | EBI_SDCOL_10BIT_gc | EBI_SDCAS_bm;  //CL=3, ROW=12, COL=10 bitw
	EBI.SDRAMCTRLB=EBI_MRDLY_2CLK_gc | EBI_ROWCYCDLY_7CLK_gc | EBI_RPDLY_7CLK_gc; //Odstpy pomidzy komendami
	EBI.SDRAMCTRLC=EBI_WRDLY_1CLK_gc | EBI_ESRDLY_7CLK_gc | EBI_ROWCOLDLY_7CLK_gc;
	EBI.INITDLY=F_CLKPER2*0.0002;           //Czas inicjalizacji moduu, co najmniej 100us, wic dla pewnoci dajemy 200

	EBI.CTRL=EBI_SDDATAW_4BIT_gc | EBI_IFMODE_3PORT_gc;  //SDRAM z 4-bitow szyn danych, tryb 3-portowy
	EBI.REFRESH=(F_CLKPER2*64/1000)/2^12;   //Czas odwieania, zaley od zegara CLKPER2 i iloci rzdw

	//EBI.CS3.BASEADDR=(0x800000ul>>8) & 0xFFF0;      //Adres pocztku pamici w przestrzeni adresowej (od adresu 0x4000)
	EBI.CS3.BASEADDR=(0x000000ul>>8) & 0xFFF0;      //Adres pocztku pamici w przestrzeni adresowej (od adresu 0x4000)
    EBI.CS3.CTRLB=EBI_CS_SDMODE_NORMAL_gc;
	EBI.CS3.CTRLA=EBI_CS_ASIZE_8MB_gc | EBI_CS_MODE_SDRAM_gc;   //Pami ma pojemno 8MB, typ SDRAM

    while(!(EBI.CS3.CTRLB & EBI_CS_SDINITDONE_bm));
}

volatile uint8_t v;

int main(void)
{
	SDRAM_init();
	
	volatile uint8_t *ptr=0x8001;
	*ptr=123;
	v=*ptr;
	*ptr=99;
	v=*ptr;
		
    while(1)
    {
        //TODO:: Please write your application code 
    }
}