/*
 * Menu.c
 *
 * Created: 2013-08-19 07:31:25
 *  Author: tmf
 */


#include <avr/io.h>
#include "SPI/SPI.h"
#include "st7565/ST7565.h"
#include <stdbool.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include "menu.h"

#include <util/delay.h>

extern const __flash uint8_t* const __flash system16_array[];
extern const __flash uint8_t* const __flash system12_array[];
extern const __flash uint8_t* const __flash system8_array[];

void LCD_BackLight_Init()
{
	PORTE_DIRSET=PIN4_bm;     //Pin sterujcy bramk MOSFETa
	TCE1.CTRLB=TC1_CCAEN_bm | TC_WGMODE_SINGLESLOPE_gc;  //Tryb SS, CCA odblokowane
	TCE1.CCA=0x0080;          //Wypenienie 50%
	TCE1.PER=0x00ff;
	TCE1.CTRLA=TC_CLKSEL_DIV1_gc;
}

void LCD_BackLight_Set(uint8_t intensity)
{
	TCE1_CCA=intensity;
}

void LCD_Init()
{
	PORTA.OUTSET=PIN3_bm;     //Pin RESET
	PORTA.DIRSET=PIN3_bm;
	PORTD_DIRSET=PIN0_bm;     //Pin A0 - wybr dane/polecenie
	PORTF.OUTSET=PIN3_bm;
	PORTF.DIRSET=PIN3_bm;     //Sygna CS kontrolera
	st7565r_init();           //Zainicjuj kontroler
}

volatile uint8_t Buttons;         //Stan przyciskw - 1 wcinity, 0 - zwolniony

ISR(TCF0_OVF_vect)
{
	static uint8_t counters[3];     //Pomocnicze liczniki dla SW0, SW1 i SW2

	uint8_t tmpbtn=0;
	tmpbtn=((PORTE_IN & PIN5_bm) == 0);
	tmpbtn|=(((PORTF_IN & PIN1_bm) == 0) << 1);
	tmpbtn|=(((PORTF_IN & PIN2_bm) == 0) << 2);

	uint8_t btnmask=1;
	for(uint8_t i = 0; i < sizeof(counters)/sizeof(counters[0]); i++)
	{
		if(counters[i]==0)              //Nie eliminujemy aktualnie drga
		{
			if((tmpbtn ^ Buttons) & btnmask)
			{
				Buttons=(Buttons & (~btnmask)) | (tmpbtn & btnmask); //Przepisz stan klawisza
				counters[i]=20;	//Czas przez jaki stan przycisku bdzie ignorowany
			}
		} else --counters[i];  //Zmniejszaj licznik do 0
		btnmask<<=1;
	}
}

void Kbd_init()
{
	PORTE_DIRCLR=PIN5_bm;                 //Waciwie niepotrzebne, gdy domylnie te piny s wejciem, przycisk SW0
	PORTF_DIRCLR=PIN1_bm | PIN2_bm;       //Przyciski SW1 i SW2
	TCF0.CTRLB=TC_WGMODE_NORMAL_gc;       //Zwyky tryb pracy timera
	TCF0.PER=(F_CPU/1000)-1;              //Sprawdzamy klawisze co okoo 1 ms
	TCF0.INTCTRLA=TC_OVFINTLVL_LO_gc;
	TCF0.CTRLA=TC_CLKSEL_DIV1_gc;
}

int main(void)
{
	static uint8_t OldButtons;  //Poprzedni stan klawiszy
	LCD_BackLight_Init();
	SPI_init();
	Kbd_init();              //Obsuga przyciskw

	PMIC.CTRL = PMIC_LOLVLEN_bm; //Wczamy przerwania
	sei();

	PORTF.OUTSET=PIN4_bm;    //Sygna CS pamici DataFLASH na pytce Xplained
	PORTF.DIRSET=PIN4_bm;
	//	PORTC.OUTSET=PIN2_bm | PIN3_bm | PIN4_bm; //Jeli mamy podczon pytk z TP, Flash i zczem SD na pokadzie
	//	PORTC.DIRSET=PIN2_bm | PIN3_bm | PIN4_bm;

	LCD_Init();
	st7565r_Clear(false);

	Menu_Show();

	while(1)
	{
		uint8_t tmpbtn=Buttons;
		if(((tmpbtn ^ OldButtons) & 1) && (tmpbtn & 1)) Menu_Click();       //Wcinity SW1
		if(((tmpbtn ^ OldButtons) & 2) && (tmpbtn & 2)) Menu_SelectPrev();  //Wcinity SW1
		if(((tmpbtn ^ OldButtons) & 4) && (tmpbtn & 4)) Menu_SelectNext();  //Wcinity SW2
		OldButtons=tmpbtn;
	}
}