/*-----------------------------------------------------------------------*/
/* Low level disk I/O module skeleton for Petit FatFs (C)ChaN, 2009      */
/*-----------------------------------------------------------------------*/

#include "diskio.h"
#include "AT45CMD.h"                    //Dodaj polecenia pamici DataFLASH
#include "DataFLASH.h"                  //Dodaj transakcyjn obsuge pamici
#include <string.h>


/*-----------------------------------------------------------------------*/
/* Initialize Disk Drive                                                 */
/*-----------------------------------------------------------------------*/

DSTATUS disk_initialize (void)
{
	return 0;  //Nic nie musimy inicjalizowa
}



/*-----------------------------------------------------------------------*/
/* Read Partial Sector                                                   */
/*-----------------------------------------------------------------------*/

DRESULT disk_readp (
	BYTE* dest,			/* Pointer to the destination object */
	DWORD sector,		/* Sector number (LBA) */
	WORD sofs,			/* Offset in the sector */
	WORD count			/* Byte count (bit15:destination) */
)
{
	uint8_t bufor[sizeof(SPI_Transact) + 4 + count];  //Miejsce na bufor transakcji + wielko sektora
	SPI_Transact *trans=(SPI_Transact*)&bufor;

	uint8_t dato=DataFlash_AddTransaction(AT45DBX_CMDA_RD_ARRAY_LF_SM, (sector / 2) * DataFLASH_PageSize + (sector & 1) * 512 + sofs, bufor, count, true); //Odczytaj dane z pamici
	if(dest) memcpy(dest, &trans->data[dato], count);        //Skopiuj dane z bufora transakcji do miejsca docelowego

	return RES_OK;
}



/*-----------------------------------------------------------------------*/
/* Write Partial Sector                                                  */
/*-----------------------------------------------------------------------*/

DRESULT disk_writep (
	const BYTE* buff,		/* Pointer to the data to be written, NULL:Initiate/Finalize write operation */
	DWORD sc	        	/* Sector number (LBA) or Number of bytes to send */
)
{
	static __uint24 LastSector;      //Nr sektora dla ktrego rozpoczelimy inicjalizacj zapisu
	static uint16_t SectorOffset;    //Aktualna pozycja zapisu w biecym sektorze (buforze DataFLASH)

	if (!buff) {
		if (sc) {

			// Initiate write process
			uint8_t bufor[sizeof(SPI_Transact) + 4];
			SectorOffset=(sc & 1) * 512;               //Bajty bd zapisywane od offsetu 0 lub 512 w zalenoci od parzystoci numeru sektora
			LastSector=(sc / 2) * DataFLASH_PageSize;  //Oblicz pozycj sektora w pamici DataFLASH
			DataFlash_AddTransaction(AT45DBX_CMDB_XFR_PAGE_TO_BUF1, LastSector, bufor, 0, false); //Przepisz dane z pamici do bufora 1 DataFLASH
			DataFLASH_WaitForReady();   //Zaczekaj na koniec transferu
		} else {

			// Finalize write process
			uint8_t bufor[sizeof(SPI_Transact) + 4];
			DataFlash_AddTransaction(AT45DBX_CMDB_PR_BUF1_TO_PAGE_ER, LastSector, bufor, 0, true); //Zapisz dane z bufora 1 do DataFLASH
			DataFLASH_WaitForReady();   //Zaczekaj na koniec zapisu
		}
	} else {

		// Send data to the disk
		uint8_t bufor[sizeof(SPI_Transact) + 4 + sc];
		SPI_Transact *trans=(SPI_Transact*)&bufor;
		memcpy(&trans->data[4], buff, sc);         //Skopiuj dane do bufora transakcji
		DataFlash_AddTransaction(AT45DBX_CMDC_WR_BUF1, SectorOffset, bufor, sc, true); //Zapisz dane do bufora 1 DataFLASH
		SectorOffset+=sc;   //Zmieniamy pozycj zapisu w buforze
	}

	return RES_OK;
}

