/*
 * ADC.c
 *
 * Created: 2013-07-28 16:37:48
 *  Author: tmf
 */

#include <avr/io.h>
#include <avr/pgmspace.h>
#include <stddef.h>
#include <avr/interrupt.h>
#include <string.h>
#include <stdio.h>
#include <asf.h>
#include "ADC.h"

ADC_Result_t ADC_Res[2][ADC_BUF_SIZE];  //Bufor na dane
volatile uint8_t ADC_Res_Page;          //Strona zawierajca wyniki
uint16_t Timestamp;                     //Licznik ramek


void SendData()
{
	char temp[60];
	for(uint16_t i=0; i < ADC_BUF_SIZE; i++)
	{
		sprintf(temp, "Timestamp: %d CH0: %ld, CH1: %ld, CH2: %ld, CH3: %ld\r\n", Timestamp,
				ADC_Res[ADC_Res_Page][i].CH[0]*1000L/2048, ADC_Res[ADC_Res_Page][i].CH[1]*1000L/2048,
				ADC_Res[ADC_Res_Page][i].CH[2]*1000L/2048, ADC_Res[ADC_Res_Page][i].CH[3]*1000L/2048);
		udi_cdc_write_buf(temp, strlen(temp));
		Timestamp++;
	}
}

ISR(DMA_CH0_vect)
{
	ADC_Res_Page=0;
	DMA_CH0_CTRLB=DMA_CH_TRNINTLVL_LO_gc | DMA_CH_TRNIF_bm;  //Skasuj flag przerwania
	SendData();
}

ISR(DMA_CH1_vect)
{
	ADC_Res_Page=1;
	DMA_CH1_CTRLB=DMA_CH_TRNINTLVL_LO_gc | DMA_CH_TRNIF_bm;  //Skasuj flag przerwania
	SendData();
}

uint8_t ReadCalibrationByte(uint8_t index)
{
	uint8_t result;

	NVM_CMD=NVM_CMD_READ_CALIB_ROW_gc; //Odczytaj sygnatur produkcyjn
	result=pgm_read_byte(index);

	NVM_CMD=NVM_CMD_NO_OPERATION_gc;   //Przywr normalne dziaanie NVM
	return result;
}

void ADC_CH_Init(ADC_CH_t *adcch, register8_t muxpos)
{
	adcch->CTRL=ADC_CH_INPUTMODE_SINGLEENDED_gc;  //Tryb pojedynczego wejcia ze znakiem
	adcch->MUXCTRL=muxpos;                        //Pin wejcia dodatniego
}

void Timer_Init()
{
	TCC0.CTRLB=TC_WGMODE_NORMAL_gc;        //Zwyky tryb pracy timera
	TCC0.PER=F_CPU/256;                    //Odliczamy 1 sekund
	TCC0.CCA=0;                            //Zdarzenie z kanau A co 1 sekund
	EVSYS_CH0MUX=EVSYS_CHMUX_TCC0_CCA_gc;  //Routowane do kanau zdarze nr 0
	TCC0.CTRLA=TC_CLKSEL_DIV256_gc;        //Taktowanie mniej wicej 62,5 kHz
}

void DMA_CH_Init(DMA_CH_t *DMA_CH, uint16_t DstAddr)
{
	DMA_CH->ADDRCTRL=DMA_CH_SRCDIR_INC_gc | DMA_CH_DESTDIR_INC_gc | DMA_CH_SRCRELOAD_BURST_gc | DMA_CH_DESTRELOAD_BLOCK_gc;
	DMA_CH->TRIGSRC=DMA_CH_TRIGSRC_ADCA_CH3_gc; //Transfer wyzwala zakoczenie konwersji w CH3
	DMA_CH->TRFCNT=ADC_BUF_SIZE*sizeof(ADC_Result_t);
	DMA_CH->REPCNT=0;  //Powtarzamy w nieskoczono
	DMA_CH->SRCADDR0=((uint16_t)&ADCA_CH0RES) & 0xff;
	DMA_CH->SRCADDR1=((uint16_t)&ADCA_CH0RES) >> 8;
	DMA_CH->SRCADDR2=0;
	DMA_CH->DESTADDR0=DstAddr & 0xff;
	DMA_CH->DESTADDR1=DstAddr >> 8;
	DMA_CH->DESTADDR2=0;
	DMA_CH->CTRLB=DMA_CH_TRNINTLVL_LO_gc;
	DMA_CH->CTRLA=DMA_CH_ENABLE_bm | DMA_CH_SINGLE_bm | DMA_CH_BURSTLEN_8BYTE_gc | DMA_CH_REPEAT_bm; //Tryb single, transferujemy na raz 8 bajtw
}

void DMA_Init()
{
	DMA_CH_Init(&DMA.CH0, (uint16_t)&ADC_Res[0][0]);
	DMA_CH_Init(&DMA.CH1, (uint16_t)&ADC_Res[1][0]);
	DMA.CTRL=DMA_ENABLE_bm | DMA_DBUFMODE_CH01_gc;    //Odblokuj DMAC, podwjne buforowanie prze kanay 0 i 1, round-robin
}

void ADC_Init()
{
	ADCA.CTRLA=ADC_ENABLE_bm;// | ADC_DMASEL_CH0123_gc;   //Wszystkie kanay wyzwalaj transfer DMA
	ADCA.CTRLB=ADC_CONMODE_bm;                         //Rozdzielczo 12 bitw, tryb ze znakiem
	ADCA.REFCTRL=ADC_REFSEL_INT1V_gc | ADC_BANDGAP_bm; //Referencja 1V
	ADCA.EVCTRL=ADC_SWEEP_0123_gc | ADC_EVSEL_0123_gc | ADC_EVACT_SWEEP_gc; //Wyzwalanie kanaw 0, 1, 2 i 3 przez EVCH0
	ADCA.PRESCALER=ADC_PRESCALER_DIV16_gc;     //CLKADC=1 MHz
	ADCA.CALL=ReadCalibrationByte(offsetof(NVM_PROD_SIGNATURES_t, ADCACAL0));
	ADCA.CALH=ReadCalibrationByte(offsetof(NVM_PROD_SIGNATURES_t, ADCACAL1));

	ADC_CH_Init(&ADCA.CH0, ADC_CH_MUXPOS_PIN0_gc);   //Zainicjuj poszczeglne kanay ADC
	ADC_CH_Init(&ADCA.CH1, ADC_CH_MUXPOS_PIN1_gc);
	ADC_CH_Init(&ADCA.CH2, ADC_CH_MUXPOS_PIN2_gc);
	ADC_CH_Init(&ADCA.CH3, ADC_CH_MUXPOS_PIN3_gc);
	DMA_Init();
	Timer_Init();
}

uint16_t ADC_GetResults()
{
	uint32_t accum=0;
	uint16_t counter=0;
	do{
		ADCA.CH0.CTRL|=ADC_CH_START_bm;     //Rozpocznij konwersj
		while(!(ADCA.CH0.INTFLAGS & ADC_CH_CHIF_bm)); //Zaczekaj na koniec
		ADCA.CH0.INTFLAGS=ADC_CH_CHIF_bm;             //Skasuj flag koca przetwarzania
		accum+=ADCA.CH0RES;
		counter++;
	} while(counter<1024);
	return accum/1024;
}