/*
 * KBD.c
 *
 * Created: 2013-10-31 14:23:01
 *  Author: tmf
 */

#include <avr/io.h>
#include <avr/interrupt.h>
#include "KBD.h"

volatile uint8_t Buttons;         //Stan przyciskw - 1 wcinity, 0 - zwolniony

ISR(TCF0_OVF_vect)
{
	static uint8_t counters[KBD_NUM];     //Pomocnicze liczniki dla SW0, SW1 i SW2

	uint8_t tmpbtn=0;
	tmpbtn=((PORTE_IN & PIN5_bm) == 0);
	tmpbtn|=(((PORTF_IN & PIN1_bm) == 0) << 1);
	tmpbtn|=(((PORTF_IN & PIN2_bm) == 0) << 2);

	uint8_t btnmask=1;
	for(uint8_t i = 0; i < sizeof(counters)/sizeof(counters[0]); i++)
	{
		if(counters[i]==0)              //Nie eliminujemy aktualnie drga
		{
			if((tmpbtn ^ Buttons) & btnmask)
			{
				Buttons=(Buttons & (~btnmask)) | (tmpbtn & btnmask); //Przepisz stan klawisza
				counters[i]=20;	//Czas przez jaki stan przycisku bdzie ignorowany
			}
		} else --counters[i];  //Zmniejszaj licznik do 0
		btnmask<<=1;
	}
}

void Kbd_init()
{
	PORTE_DIRCLR=PIN5_bm;                 //Waciwie niepotrzebne, gdy domylnie te piny s wejciem, przycisk SW0
	PORTF_DIRCLR=PIN1_bm | PIN2_bm;       //Przyciski SW1 i SW2
	TCF0.CTRLB=TC_WGMODE_NORMAL_gc;       //Zwyky tryb pracy timera
	TCF0.PER=(F_CPU/1000)-1;              //Sprawdzamy klawisze co okoo 1 ms
	TCF0.INTCTRLA=TC_OVFINTLVL_LO_gc;
	TCF0.CTRLA=TC_CLKSEL_DIV1_gc;
}