/*
 * LCD_trans_int.c
 *
 * Created: 2012-08-18 12:02:52
 *  Author: tmf
 */ 


#include <stdlib.h>
#include <string.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include "defines.h"
#include "PinMacros.h"
#include "Alloc_safe.h"
#include "LCD_trans.h"

ISR(TCD1_OVF_vect)
{
	static char int_buf[sizeof(LCD_trans) + 7];
	static uint16_t cnt;
	char bufstr[6];
	
	utoa(cnt++, bufstr, 10);
	while(strlen(bufstr)<6) strcat(bufstr, " ");
	LCD_PutText_B(6,1, bufstr, (LCD_trans*)&int_buf, false);
}

void strchg(char txt[])
{
	txt[0]=0;
}

int main(void)
{
	LCD_init();
	LCD_Timer_init(&TCD0);
	
	TCD1_INTCTRLA=TC_OVFINTLVL_LO_gc;   //Odblokuj przerwania nadmiaru timera i najdaj im niski priorytet
    TCD1_CTRLA=TC_CLKSEL_DIV64_gc;      //Taktowanie timera F_CPU/64
	
	PMIC_CTRL|=PMIC_LOLVLEN_bm;     //Odblokuj przerwania niskiego poziomu
	sei();
	
	LCD_PutText(0,0, "Numer:");
	LCD_PutText(0,1, "INT  :");
	uint16_t cnt=0;
	LCD_trans *buf=malloc_re(sizeof(LCD_trans) + 7);
	char bufstr[6];
	
	while(1)
	{
		utoa(cnt++, bufstr, 10);
		while(strlen(bufstr)<6) strcat(bufstr, " ");
		LCD_PutText_B(6,0, bufstr, buf, false);
		while(!LCD_IsTransCompleted(buf));
	}
}