/*
 * AT45IO.c
 *
 * Created: 2013-04-25 20:24:19
 *  Author: tmf
 */ 

#include <avr/io.h>
#include <math.h>
#include "AT45CMD.h"
#include "AT45IO.h"
#include "SPI.h"

void DataFLASH_CSEnable(_Bool cs)
{
	 if(cs) PORTF_OUTCLR=DataFLASH_CS;
	 else PORTF_OUTSET=DataFLASH_CS;
}

void DataFLASH_SendCmd(uint8_t cmd, void *result, uint8_t result_size)
{
	DataFLASH_CSEnable(true);
	SPI_RW_Byte(cmd); //Wylij polecenie
	for(uint8_t i=0; i<result_size; i++) *(uint8_t*)result++=SPI_RW_Byte(0);
	DataFLASH_CSEnable(false);
}

void DataFLASH_SendCmdAddr(uint8_t cmd, uint8_t addbytes, __uint24 addr, DataFLASHCS cs)
{
	if(DataFLASH_Granularity==false)
		if(cmd != 0xC7) addr=((addr / DataFLASH_PageSize) << (uint8_t)round(log(DataFLASH_PageSize) / log(2) + 0.5)) | (addr % DataFLASH_PageSize); //Nie przeliczamy dla polecenia ChipErase

	DataFLASH_CSEnable(true);
	SPI_RW_Byte(cmd);                   //Wylij polecenie
	SPI_RW_Byte((addr >> 16) & 0xff);  //Wylij 3 bajty tworzce 24-bitowy adres
	SPI_RW_Byte((addr >> 8) & 0xff);
	SPI_RW_Byte(addr & 0xff);
	for(uint8_t i=0; i<addbytes; i++) SPI_RW_Byte(0);  //Wylij dodatkowe wymagane bajty - bez znaczenia jakie
	DataFLASH_CSEnable(!cs);
}

void DataFLASH_ReadSeq(__uint24 addr, void *bufor, __uint24 size)
{
	DataFLASH_SendCmdAddr(AT45DBX_CMDA_RD_ARRAY_AF_SM, addr, CS_Low);  //Wylij polecenie odczytu danych
	for(__uint24 i=0; i<size; i++)                             //Odczytaj size bajtw z pamici
	{
		*(uint8_t*)bufor=SPI_RW_Byte(0);
		++bufor;
	}
	DataFLASH_CSEnable(false);	                               //Zakocz polecenie
}

void DataFLASH_WaitForBusy()
{
	DataFLASH_Status DF_Status;  //Miejsce na rejestr stanu
	do {
		DataFLASH_SendCmd(AT45DBX_CMDC_RD_STATUS_REG, ADDRANDSIZE(DF_Status));  //Pobierz warto rejestru stanu
	} while(DF_Status.BUSY==0);
}
