/*
 * DAC8_bit.c
 *
 * Created: 2012-03-24 10:50:45
 *  Author: tmf
 */ 


#include <avr/io.h>
uint8_t wave[] ={0,4096>>8, 8192>>8, 12288>>8, 16384>>8, 20480>>8, 24576>>8, 28672>>8, 32768>>8, 36863>>8, 40959>>8, 45055>>8, 49151>>8, 53247>>8, 57343>>8,      //32 prbki 8-bitowe
	61439>>8, 57343>>8, 53247>>8, 49151>>8, 45055>>8, 40959>>8, 36863>>8, 32768>>8, 28672>>8, 24576>>8, 20480>>8, 16384>>8, 12288>>8, 8192>>8, 4096>>8};

void DAC_init()
{
	DACA.CTRLC=DAC_REFSEL_INT1V_gc | DAC_LEFTADJ_bm;          //Wewn. napicie ref. 1 V, wyrwnanie do lewej rejestru danych
	DACA.TIMCTRL=DAC_CONINTVAL_16CLK_gc;     //CLK/4
	DACA.CTRLB=DAC_CH0TRIG_bm;               //Konwersja wyzwalana zdarzeniem
	DACA.EVCTRL=DAC_EVSEL_0_gc;              //EvCh 0
	EVSYS_CH0MUX=EVSYS_CHMUX_PRESCALER_1_gc; //taktowanie EVCH0 z CLKPer
	DACA.CTRLA=DAC_ENABLE_bm | DAC_CH0EN_bm; //Wcz DAC, kana 0 routowany na IO (PA2)
}

void DMA_init()
{
	DMA.CTRL=DMA_ENABLE_bm;  //Odblokuj kontroler DMA, round robin, bez double buffering
	
	DMA.CH0.ADDRCTRL=DMA_CH_SRCRELOAD_BLOCK_gc | DMA_CH_SRCDIR_INC_gc | DMA_CH_DESTDIR_INC_gc | DMA_CH_DESTRELOAD_BURST_gc; //Zwiekszamy adres rda i przeznaczenia, reload adresu co blok, adres docelowy co paczk
	DMA.CH0.TRIGSRC=DMA_CH_TRIGSRC_DACA_CH0_gc; //Zdarzeniem wyzwalajcym jest pusty rejestr danych kanau CH0 DACA
	DMA.CH0.TRFCNT=sizeof(wave);                //Blok ma dugo tablicy prbek
	DMA.CH0.REPCNT=0;                           //Transfer bdzie pwtarzany w nieskoczono
	DMA.CH0.SRCADDR0=(uint16_t)&wave & 0xFF;
	DMA.CH0.SRCADDR1=(uint16_t)&wave >>8;
	DMA.CH0.SRCADDR2=0;                        //rdem danych jest tablica wave
	DMA.CH0.DESTADDR0=(uint16_t)(&DACA.CH0DATAH) & 0xFF; //Dane wpisujemy do rejestru DATA ukadu DAC
	DMA.CH0.DESTADDR1=(uint16_t)(&DACA.CH0DATAH) >> 8;
	DMA.CH0.DESTADDR2=0;
	DMA.CH0.CTRLA=DMA_CH_ENABLE_bm | DMA_CH_REPEAT_bm | DMA_CH_BURSTLEN_1BYTE_gc | DMA_CH_SINGLE_bm;  //Kana 0 w trybie powtarzania, dugo transferu 1 bajt, single shot	
}

int main(void)
{
	DMA_init();
	DAC_init();
	
    while(1) {}
}