/*
 * DAC2CH2.c
 *
 * Created: 2012-03-24 13:30:51
 *  Author: tmf
 */ 


#include <avr/io.h>

uint16_t wave[][2] = {{0>>4, 32768>>4}, {3641>>4, 38458>>4}, {7282>>4, 43975>>4}, {10923>>4, 49151>>4}, {14563>>4, 53830>>4}, {18204>>4, 57869>>4}, {21845>>4, 61145>>4},
                      {25486>>4, 63559>>4}, {29127>>4, 65037>>4}, {32768>>4, 65535>>4}, {36408>>4, 65037>>4}, {40049>>4, 63559>>4}, {43690>>4, 61145>>4}, {47331>>4, 57869>>4},
					  {50972>>4, 53830>>4}, {54613>>4, 49151>>4}, {58253>>4, 43975>>4}, {61894>>4, 38458>>4}, {65535>>4, 32768>>4}, {61894>>4, 27077>>4}, {58253>>4, 21560>>4},
					  {54613>>4, 16384>>4}, {50972>>4, 11705>>4}, {47331>>4, 7666>>4}, {43690>>4, 4390>>4}, {40049>>4, 1976>>4}, {36408>>4, 498>>4}, {32768>>4, 0>>4}, {29127>>4, 498>>4},
					  {25486>>4, 1976>>4}, {21845>>4, 4390>>4}, {18204>>4, 7666>>4}, {14563>>4, 11705>>4}, {10923>>4, 16384>>4}, {7282>>4, 21560>>4}, {3641>>4, 27077>>4}};

void DAC_init()
{
	DACA.CTRLC=DAC_REFSEL_INT1V_gc;                //Wewn. napicie ref. 1 V
	DACA.TIMCTRL=DAC_CONINTVAL_32CLK_gc | DAC_REFRESH_128CLK_gc;           //CLK/32
	DACA.CTRLB=DAC_CH0TRIG_bm | DAC_CH1TRIG_bm | DAC_CHSEL_DUAL_gc; //Konwersja wyzwalana zdarzeniem, dwukanaowa
	DACA.EVCTRL=DAC_EVSEL_0_gc;              //EvCh 0
	EVSYS_CH0MUX=EVSYS_CHMUX_PRESCALER_1_gc; //taktowanie evch0 z CLKPer
	DACA.CTRLA=DAC_ENABLE_bm | DAC_CH0EN_bm | DAC_CH1EN_bm; //Wcz DAC, kana 0 i 1 routowany na IO (PA2 i PA3)
}

void DMA_init()
{
	DMA.CTRL=DMA_ENABLE_bm;  //Odblokuj kontroler DMA, round robin, bez double buffering
	
	DMA.CH0.ADDRCTRL=DMA_CH_SRCRELOAD_BLOCK_gc | DMA_CH_SRCDIR_INC_gc | DMA_CH_DESTDIR_INC_gc | DMA_CH_DESTRELOAD_BURST_gc; //Zwiekszamy adres rda i przeznaczenia, reload adresu co blok, adres docelowy co paczk
	DMA.CH0.TRIGSRC=DMA_CH_TRIGSRC_DACA_CH0_gc; //Zdarzeniem wyzwalajcym jest pusty rejestr danych kanau CH0 DACA
	DMA.CH0.TRFCNT=sizeof(wave);                //Blok ma dugo tablicy prbek
	DMA.CH0.REPCNT=0;                           //Transfer bdzie pwtarzany w nieskoczono
	DMA.CH0.SRCADDR0=(uint16_t)&wave & 0xFF;
	DMA.CH0.SRCADDR1=(uint16_t)&wave >>8;
	DMA.CH0.SRCADDR2=0;                        //rdem danych jest tablica wave
	DMA.CH0.DESTADDR0=(uint16_t)(&DACA.CH0DATA) & 0xFF; //Dane wpisujemy do rejestru DATA ukadu DAC
	DMA.CH0.DESTADDR1=(uint16_t)(&DACA.CH0DATA) >> 8;
	DMA.CH0.DESTADDR2=0;
	DMA.CH0.CTRLA=DMA_CH_ENABLE_bm | DMA_CH_REPEAT_bm | DMA_CH_BURSTLEN_4BYTE_gc | DMA_CH_SINGLE_bm;  //Kana 0 w trybie powtarzania, dugo transferu 4 bajty, single shot		
}

int main(void)
{
	DMA_init();
	DAC_init();	
	
    while(1)
    {
        //TODO:: Please write your application code 
    }
}