/*
 * RTC.c
 *
 * Created: 2012-12-26 11:44:26
 *  Author: tmf
 */

#include "RTC.h"
#include <calendar.h>
#include <util/delay.h>
#include <avr/eeprom.h>
#include <avr/interrupt.h>

enum BatStates {Bat_FirstTime=0xff, Bat_Normal=0x00};
enum BatStates Bat_State EEMEM=Bat_FirstTime;          //Czy wczamy pierwszy raz?

struct calendar_date dt;           //Aktualna data i czas

void RTC32_initWOTime()
{
	uint32_t cnt=RTC32_get_counter();
	if(cnt & 1) RTC32.COMP=cnt+3; else RTC32.COMP=cnt+2; //Zadbaj, aby przerwanie byo generowane w odpowiedniej chwili
	while(RTC32.SYNCCTRL & RTC32_SYNCBUSY_bm); //Poczekaj na synchronizacj
	RTC32.INTCTRL=RTC32_COMPINTLVL_LO_gc;      //Odblokuj przerwania porwnania
}

void RTC32_init()
{
	RTC32.CTRL &= ~RTC32_ENABLE_bm; //Zablokuj RTC na czas inicjalizacji
	while(RTC32.SYNCCTRL & RTC32_SYNCBUSY_bm); //Poczekaj na synchronizacj
	RTC32.PER=-1;   //Okres RTC

    uint32_t dt=calendar_date_to_timestamp(&(struct calendar_date){0, 0, 0, 0, 0, 2013}); //Zainicjuj timer czasem pocztkowym
    RTC32_set_counter(dt);                     //Ustaw czas i moment przerwania
	RTC32.CTRL=RTC32_ENABLE_bm;                //Wacz RTC
    RTC32.INTCTRL=RTC32_COMPINTLVL_LO_gc;      //Odblokuj przerwania porwnania
    while(RTC32.SYNCCTRL & RTC32_SYNCBUSY_bm); //Poczekaj na synchronizacj
}

void RTC32_set_counter(uint32_t cnt)
{
	if(cnt & 1) RTC32.COMP=cnt+3; else RTC32.COMP=cnt+2; //Zadbaj, aby przerwanie byo generowane w odpowiedniej chwili
	RTC32.CNT=cnt;
	while (RTC32.SYNCCTRL & RTC32_SYNCCNT_bm);
}

uint8_t BatBackup_status()
{
	if(VBAT.STATUS & VBAT_BBPWR_bm) return 1;    //Brak zasilania
	if(VBAT.STATUS & VBAT_BBPORF_bm) return 2;   //Niewystarczajce zasilanie
	VBAT.CTRL=VBAT_ACCEN_bm;
	if(VBAT.STATUS & VBAT_XOSCFAIL_bm) return 3; //Awaria oscylatora
	return 0;
}

void BatBcakup_reset()
{
	VBAT.CTRL = VBAT_ACCEN_bm;  //Odblokuj modu
	CCP = CCP_IOREG_gc;         //Odblokuj dostp do IO
	VBAT.CTRL = VBAT_RESET_bm;  //Zresetuj jego stan
}

void BatBackup_xosc()
{
	VBAT.CTRL|=VBAT_XOSCFDEN_bm;  //Wcz monitor oscylatora
	_delay_us(200);               //Poczekaj na stabilizacj napicia
	VBAT.CTRL |= VBAT_XOSCEN_bm;  //Wcz oscylator
}

void BatBackup_init()
{
	enum BatStates bs=eeprom_read_byte(&Bat_State);
	if((bs==Bat_Normal) && (BatBackup_status()==0))
	    RTC32_initWOTime();  //Musimy ustawi wszystko z wyjtkiem CNT
	 else
	 {
		 eeprom_update_byte(&Bat_State, Bat_Normal); //Zmie stan komrki
		 BatBcakup_reset();                //Zresetuj ukad podtrzymywania
		 BatBackup_xosc();                 //Wcz oscylator
		 RTC32_init();                     //Zainicjuj RTC32
	 }
	PMIC_CTRL|=PMIC_LOLVLEN_bm;       //Odblokuj przerwania niskiego poziomu
}

ISR(RTC32_COMP_vect)
{
	uint32_t cnt=RTC32_get_counter();          //Pobierz licznik (timestamp)
	RTC32_COMP=cnt+2;                          //Kolejne przerwanie
	calendar_timestamp_to_date(cnt, &dt);      //Konwersja do "normalnego" zapisu czasu
}
