/*
 * ADC.c
 *
 * Created: 2013-07-28 16:37:48
 *  Author: tmf
 */

#include <avr/io.h>
#include <avr/pgmspace.h>
#include <stddef.h>
#include <avr/interrupt.h>
#include <string.h>
#include <stdio.h>
#include <asf.h>

ISR(ADCA_CH0_vect)
{
	char temp[30];
	sprintf(temp, "CH0: %ld mV\r\n", ((int)ADCA_CH0_RES)*1000L/2048);
	udi_cdc_write_buf(temp, strlen(temp));
}

ISR(ADCA_CH1_vect)
{
	char temp[30];
	sprintf(temp, "CH1: %ld mV\r\n", ((int)ADCA_CH1_RES)*1000L/2048);
	udi_cdc_write_buf(temp, strlen(temp));
}

ISR(ADCA_CH2_vect)
{
	char temp[30];
	sprintf(temp, "CH2: %ld mV\r\n", ((int)ADCA_CH2_RES)*1000L/2048);
	udi_cdc_write_buf(temp, strlen(temp));
}

ISR(ADCA_CH3_vect)
{
	char temp[30];
	sprintf(temp, "CH3: %ld mV\r\n", ((int)ADCA_CH3_RES)*1000L/2048);
	udi_cdc_write_buf(temp, strlen(temp));
}

uint8_t ReadCalibrationByte(uint8_t index)
{
	uint8_t result;

	NVM_CMD=NVM_CMD_READ_CALIB_ROW_gc; //Odczytaj sygnatur produkcyjn
	result=pgm_read_byte(index);

	NVM_CMD=NVM_CMD_NO_OPERATION_gc;   //Przywr normalne dziaanie NVM
	return result;
}

void ADC_CH_Init(ADC_CH_t *adcch, register8_t muxpos)
{
	adcch->CTRL=ADC_CH_INPUTMODE_SINGLEENDED_gc;  //Tryb pojedynczego wejcia ze znakiem
	adcch->MUXCTRL=muxpos;                        //Pin wejcia dodatniego
	adcch->INTCTRL=ADC_CH_INTMODE_COMPLETE_gc | ADC_CH_INTLVL_LO_gc;
}

void Timer_Init()
{
	TCC0.CTRLB=TC_WGMODE_NORMAL_gc;        //Zwyky tryb pracy timera
	TCC0.PER=F_CPU/256;                    //Odliczamy 1 sekund
	TCC0.CCA=0;                            //Zdarzenie z kanau A co 1 sekund
	EVSYS_CH0MUX=EVSYS_CHMUX_TCC0_CCA_gc;  //Routowane do kanau zdarze nr 0
	TCC0.CTRLA=TC_CLKSEL_DIV256_gc;        //Taktowanie mniej wicej 62,5 kHz
}

void ADC_Init()
{
	ADCA.CTRLA=ADC_ENABLE_bm;
	ADCA.CTRLB=ADC_CONMODE_bm; //Rozdzielczo 12 bitw, tryb ze znakiem
	ADCA.REFCTRL=ADC_REFSEL_INT1V_gc | ADC_BANDGAP_bm; //Referencja 1V
	ADCA.EVCTRL=ADC_SWEEP_0123_gc | ADC_EVSEL_0123_gc | ADC_EVACT_SWEEP_gc; //Wyzwalanie kanaw 0, 1, 2 i 3 przez EVCH0
	//ADCA.EVCTRL=ADC_SWEEP_01_gc | ADC_EVSEL_0123_gc | ADC_EVACT_SWEEP_gc; //Wyzwalanie kanaw 0 i 1 przez EVCH0
	ADCA.PRESCALER=ADC_PRESCALER_DIV16_gc;     //CLKADC=1 MHz
	ADCA.CALL=ReadCalibrationByte(offsetof(NVM_PROD_SIGNATURES_t, ADCACAL0));
	ADCA.CALH=ReadCalibrationByte(offsetof(NVM_PROD_SIGNATURES_t, ADCACAL1));

	ADC_CH_Init(&ADCA.CH0, ADC_CH_MUXPOS_PIN0_gc);   //Zainicjuj poszczeglne kanay ADC
	ADC_CH_Init(&ADCA.CH1, ADC_CH_MUXPOS_PIN1_gc);
	ADC_CH_Init(&ADCA.CH2, ADC_CH_MUXPOS_PIN2_gc);
	ADC_CH_Init(&ADCA.CH3, ADC_CH_MUXPOS_PIN3_gc);
	Timer_Init();
}

uint16_t ADC_GetResults()
{
	uint32_t accum=0;
	uint16_t counter=0;
	do{
		ADCA.CH0.CTRL|=ADC_CH_START_bm;     //Rozpocznij konwersj
		while(!(ADCA.CH0.INTFLAGS & ADC_CH_CHIF_bm)); //Zaczekaj na koniec
		ADCA.CH0.INTFLAGS=ADC_CH_CHIF_bm;             //Skasuj flag koca przetwarzania
		accum+=ADCA.CH0RES;
		counter++;
	} while(counter<1024); 
	return accum/1024;
}