/*
 * usart_DMA.c
 *
 * Created: 2013-01-26 15:54:44
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include <stdbool.h>
#include <avr/pgmspace.h>
#include <util/atomic.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "usart.h"
#include "bufusart.h"
#include "RingBuffer.h"
#include "DMA.h"
#include "malloc.h"

#define MAX_CMD_LEN 10      //Maksymalna dugo polecenia w bajtach

void USART_init()
{
	PORTC_OUTSET=PIN3_bm;
	PORTC_DIRSET=PIN3_bm;                          //Pin TxD musi by wyjciem
	USARTC0.CTRLA=USART_RXCINTLVL_LO_gc;           //Odblokuj przerwania odbiornika i nadajnika
	PMIC_CTRL|=PMIC_LOLVLEN_bm;                    //Odblokuj przerwanie niskiego poziomu
	USARTC0.CTRLB=USART_TXEN_bm | USART_RXEN_bm;   //Wcz nadajnik USART
	USARTC0.CTRLC=USART_CHSIZE_8BIT_gc;            //Ramka 8 bitw, bez parzystoci, 1 bit stopu
	usart_set_baudrate(&USARTC0, 9600, F_CPU);     //Szybko transmisji
	DMA_init();                                    //Zainicjuj DMA dla nadajnika USARTC0
}

const char cmd1[] PROGMEM = {"nazwa"};
const char cmd2[] PROGMEM = {"FLASH"};
const char * const cmds[] PROGMEM = {cmd1, cmd2};

bool GetToken(char txt[MAX_CMD_LEN], uint8_t len)
{
	char ch;
	for(uint8_t i=0; i<10; i++)        //Przepisz token do zmiennej txt w formacie NULLZ
	{
		if(cb_IsEmpty(&recBuf)) return false; //Bd
		ch=cb_Read(&recBuf);
		if(ch==' ') ch=0;
		txt[i]=ch;
		if(ch==0) break;
	}
	return true;
}

int32_t GetHEXArg()
{
	char txt[MAX_CMD_LEN];
	if(GetToken(txt, MAX_CMD_LEN)==false) return -1;
	return strtol(txt, NULL, 16);   //Przekonwertuj argument hex na liczb
}

uint8_t TranslateCommand()
{
	ATOMIC_BLOCK(ATOMIC_RESTORESTATE)   //Licznik odebranych komend
	{
		if(cmdrec) --cmdrec;
	}
	
	uint8_t indeks;
	char txt[MAX_CMD_LEN];
    if(GetToken(txt, MAX_CMD_LEN)==false) return -1;  //Wystpi bd
	
	for(indeks=0; indeks<sizeof(cmds)/sizeof(cmds[0]); indeks++)  //Porwnaj token z list
		if(strcmp_P(txt, cmds[indeks])==0) break;
	
	return indeks;
}

void SendFLASH(int32_t start, int32_t end)
{
	if((start==-1) || (end==-1)) 
	{
		USART_send_buf_F(&sendBuf, PSTR("Bdnie okrelone adresy pamici\r\n"));
		return;
	}
	char txt[5];
	bool ret;
	char *buf=malloc_re((((end-start)<<2)>400) ? 401 : (((end-start)<<2)+1));
	uint16_t cnt=0;
	
	for(int32_t indeks=start; indeks<end; indeks++)
	{
		sprintf(txt, "%02x, ", pgm_read_byte_far(indeks));
		strcpy(&buf[cnt], txt);
		cnt+=4;
		if((cnt==400) || (indeks==(end-1)))
		{
			cnt=0;
			while((ret=cb_Send_Add(&sendBuf, buf))==false);
			buf=malloc_re((((end-indeks)<<2)>400) ? 401 : (((end-indeks)<<2)+1));   //Nadpisujemy buf, ale nie bdzie wycieku pamici!
		}
	}
}

int main(void)
{
	USART_init();
	sei();
	
	while(1)
	{
		if(cmdrec)
		{
			switch(TranslateCommand())
			{
				case 0 : USART_send_buf_F(&sendBuf, PSTR("Nazywam sie XMEGA\r\n")); break;
				case 1 : USART_send_buf_F(&sendBuf, PSTR("Zawartosc pamieci FLASH:\r\n"));
				         SendFLASH(GetHEXArg(), GetHEXArg());
				         break;
				default: USART_send_buf_F(&sendBuf, PSTR("Nieznane polecenie\r\n"));
			}
		}
	}
}