/*
 * PWM_triangle.c
 *
 * Created: 2012-03-17 16:17:18
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <stdbool.h>
#include <util/delay.h>

//uint16_t wave[] ={0, 8192, 16384, 24576, 32768, 40959, 49151, 57343, 65535, 49151, 40959, 32768, 24576, 16384, 8192};  //15 prbek
uint16_t wave[] ={0,4096, 8192, 12288, 16384, 20480, 24576, 28672, 32768, 36863, 40959, 45055, 49151, 53247, 57343,      //32 prbki
	61439, 57343, 53247, 49151, 45055, 40959, 36863, 32768, 28672, 24576, 20480, 16384, 12288, 8192, 4096};
	
uint8_t counter;

void Timer_init()
{
	PORTC.DIRSET=0b0000001;       //PD0 jest wyjciem OC0A
	TCC0.CTRLB=TC1_CCAEN_bm | TC_WGMODE_SS_gc;       //Odblokuj rejestr compare A, tryb single slope
	TCC0.PER=0xffff;                //16-bitowy PWM
	TCC0.CTRLA=TC_CLKSEL_DIV1_gc;  //Preskaler 1
}

bool OSC_wait_for_rdy(uint8_t clk)
{
	uint8_t czas=255;
	while ((!(OSC.STATUS & clk)) && (--czas)) // Czekaj na ustabilizowanie si generatora
	 _delay_ms(1);
	return czas;   //false jeli generator nie wystartowa, true jeli jest ok
}

bool RC32M_en()
{
	OSC.CTRL |= OSC_RC32MEN_bm; //Wcz generator RC 32 MHz
	return OSC_wait_for_rdy(OSC_RC32MEN_bm); //Zaczekaj na jego poprawny start
}

int main(void)
{
	RC32M_en();   //Timer musi by taktowany jak najszybciej - 32 MHz
	
	CCP=CCP_IOREG_gc;
	CLK_CTRL=CLK_SCLKSEL_RC32M_gc;   //Przecz rdo zegara CPU
	
	Timer_init();
	
    while(1)
    {
		TCC0.CCABUF=wave[counter];          //zaaduj now prbk
		counter=(counter+1) % (sizeof(wave)/sizeof(wave[0]));  //licznik modulo liczba prbek
		while(TCC0.CTRLGCLR & TC0_CCABV_bm);  //Poczekaj na kolejny okres
    }
}