/*
 * Slave.c
 *
 * Created: 2013-02-15 13:13:44
 *  Author: tmf
 */ 


#include <avr/io.h>
#include "usart.h"
#include "RingBuffer.h"
#include <avr/interrupt.h>

CircBuffer recBuf;

ISR(USARTF0_RXC_vect)
{
	uint8_t ch=USARTF0_DATA;
	cb_Add(&recBuf, ch);
}

void USART_rec_init()
{
	USARTF0.CTRLB=USART_RXEN_bm;         //Wcz odbiornik USART
	USARTF0.CTRLC=USART_CHSIZE_8BIT_gc;  //Ramka 8 bitw, bez parzystoci, 1 bit stopu
    usart_set_baudrate(&USARTF0, 1800, F_CPU);
	PORTF_PIN2CTRL|=PORT_OPC_PULLUP_gc;  //Wyjcie odbiornika jest typu OC
	USARTF0.CTRLA=USART_RXCINTLVL_LO_gc; //Odblokuj przerwania odbiornika
	PMIC_CTRL|=PMIC_LOLVLEN_bm;          //Odblokuj przerwanie niskiego poziomu
}

void USART_PC_init()
{
	USARTC0.CTRLB=USART_TXEN_bm;         //Wcz nadajnik USART
	USARTC0.CTRLC=USART_CHSIZE_8BIT_gc;  //Ramka 8 bitw, bez parzystoci, 1 bit stopu
	usart_set_baudrate(&USARTC0, 9600, F_CPU);
	PORTC_OUTSET=PIN3_bm;
	PORTC_DIRSET=PIN3_bm;  //Pin TxD musi by wyjciem w stanie wysokim
}

int main(void)
{
	USART_rec_init();
	USART_PC_init();
	sei();
    while(1)
    {
        if(cb_IsEmpty(&recBuf)==false)
		 USART_putchar(&USARTC0, cb_Read(&recBuf));
    }
}