/*
 * MasterPkt.c
 *
 * Created: 2013-02-16 16:40:43
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <string.h>
#include <avr/pgmspace.h>
#include "usart.h"

typedef struct  
{
	uint8_t  Header;     //Nagwek pakietu
	uint8_t  Addr;       //Adres urzdzenia
	uint8_t  Len;        //Dugo pola danych
	char     Data[0];    //Pole danych o zmiennej dugoci
	uint16_t CRC16;      //CRC caego pakietu
} Pakiet;


#define F_CARRIER 38000UL
#define PKT_HEADER  0xFF  //Nagwek - znak wyrniajcy pocztek pakietu

void USART_init()
{
	USARTE0.CTRLB=USART_TXEN_bm;         //W??cz nadajnik USART
	USARTE0.CTRLC=USART_CHSIZE_8BIT_gc;  //Ramka 8 bitw, bez parzystoci, 1 bit stopu
	usart_set_baudrate(&USARTE0, 1800, F_CPU);

	PORTE_OUTSET=PIN3_bm;
	PORTE_DIRSET=PIN3_bm;  //Pin TxD musi by wyjciem w stanie wysokim
	PORTE_PIN3CTRL|=PORT_INVEN_bm;
}

void timer_init()
{
	TCE0.CTRLA=TC_CLKSEL_DIV1_gc;
	TCE0.CTRLB=TC_WGMODE_SINGLESLOPE_gc | TC0_CCDEN_bm;  //Na PIN3 bdzie wyprowadzony przebieg PWM
	TCE0.PER=F_CPU/F_CARRIER - 1;   //Czstotliwo nonej
	TCE0.CCD=TCE0.PER/2;            //Wype?nienie 50%
}

uint16_t doCRC16(uint8_t *Dane, uint8_t size)
{
	CRC.CTRL=CRC_RESET_RESET1_gc;
	CRC.CTRL=CRC_SOURCE_IO_gc;  //CRC16, pocztkowo 1, dane z rejestru IO
	for(;size>0; size--) CRC.DATAIN=*(Dane++);
	CRC.STATUS=CRC_BUSY_bm; //Koniec danych
	return CRC.CHECKSUM0 | CRC.CHECKSUM1<<8;
}

void SendPkt(uint8_t Dst, const char * PROGMEM txt)
{
	uint8_t pkt[sizeof(Pakiet) + strlen_P(txt) + 1];
	Pakiet *pkt_p=(Pakiet*)pkt;
	
	pkt_p->Header=PKT_HEADER;
	pkt_p->Addr=Dst;
	pkt_p->Len=strlen_P(txt) + 1;
	strcpy_P(pkt_p->Data, txt);
	uint16_t crc16=doCRC16(pkt, sizeof(pkt) - sizeof(((Pakiet*)0)->CRC16));
	pkt_p->Data[sizeof(pkt) - sizeof(Pakiet)]=crc16>>8;
	pkt_p->Data[sizeof(pkt) - sizeof(Pakiet)+1]=crc16 & 0xFF;
	USART_send_block(&USARTE0, pkt, sizeof(pkt));
}

int main(void)
{
	USART_init();
	timer_init();
	while(1)
	{
		SendPkt('A', PSTR("Pozdrowienia przeslane przez IR!\n\r"));
	}
}