/*
 * MEM_MEM1.c
 *
 * Created: 2012-03-19 16:45:49
 *  Author: tmf
 */ 


#include <avr/io.h>

volatile uint16_t src[10]={1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
volatile uint16_t dst[10];
volatile uint8_t filltbl[20];

int main(void)
{
	DMA.CTRL=DMA_ENABLE_bm;  //Odblokuj kontroler DMA, round robin, bez bouble buffering
	
	//Kopiuj src do dst
	DMA.CH0.ADDRCTRL=DMA_CH_SRCRELOAD_BLOCK_gc | DMA_CH_SRCDIR_INC_gc | DMA_CH_DESTDIR_INC_gc | DMA_CH_DESTRELOAD_BLOCK_gc; //Zwiekszamy adres rda i przeznaczenia, reload adresu co blok
	DMA.CH0.TRFCNT=sizeof(src);                 //Blok ma dugo tablicy src
	DMA.CH0.SRCADDR0=(uint16_t)&src & 0xFF;
	DMA.CH0.SRCADDR1=(uint16_t)&src >>8;
	DMA.CH0.SRCADDR2=0;                        //rdem danych jest tablica src
	DMA.CH0.DESTADDR0=(uint16_t)&dst & 0xFF;
	DMA.CH0.DESTADDR1=(uint16_t)&dst >> 8;
	DMA.CH0.DESTADDR2=0;                       
	DMA.CH0.CTRLA=DMA_CH_ENABLE_bm | DMA_CH_TRFREQ_bm | DMA_CH_BURSTLEN_2BYTE_gc;  //Kana 0 dugo transferu 2 bajty, start manualny
	while(DMA.CH0.CTRLA & DMA_CH_ENABLE_bm);  //Zaczekaj na koniec transferu
	
	//Kopiuj src do dst z odwrceniem kolejnoci elementw
	DMA.CH0.ADDRCTRL=DMA_CH_SRCRELOAD_BLOCK_gc | DMA_CH_SRCDIR_INC_gc | DMA_CH_DESTDIR_DEC_gc | DMA_CH_DESTRELOAD_BLOCK_gc; //Src jest inkrementowany, dest jest dekrementowany
	DMA.CH0.DESTADDR0=((uint16_t)(&dst[10])-1) & 0xFF;
	DMA.CH0.DESTADDR1=((uint16_t)(&dst[10])-1) >> 8;
	DMA.CH0.DESTADDR2=0; 
	DMA.CH0.CTRLA=DMA_CH_ENABLE_bm | DMA_CH_TRFREQ_bm | DMA_CH_BURSTLEN_2BYTE_gc; //Rozpocznij transfer
	while(DMA.CH0.CTRLA & DMA_CH_ENABLE_bm);  //Zaczekaj na koniec transferu
	
	//Przesu elementy w dst o jeden indeks w gr
	DMA.CH0.ADDRCTRL=DMA_CH_SRCRELOAD_BLOCK_gc | DMA_CH_SRCDIR_DEC_gc | DMA_CH_DESTDIR_DEC_gc | DMA_CH_DESTRELOAD_BLOCK_gc;
	DMA.CH0.TRFCNT=sizeof(src)-sizeof(src[0]);                 //Blok ma dugo tablicy src -1 element
	DMA.CH0.SRCADDR0=(uint16_t)(&dst[9]-1) & 0xFF;
	DMA.CH0.SRCADDR1=(uint16_t)(&dst[9]-1) >>8;
	DMA.CH0.SRCADDR2=0;
	DMA.CH0.DESTADDR0=(uint16_t)(&dst[10]-1) & 0xFF;
	DMA.CH0.DESTADDR1=(uint16_t)(&dst[10]-1) >> 8;
	DMA.CH0.DESTADDR2=0;
	DMA.CH0.CTRLA=DMA_CH_ENABLE_bm | DMA_CH_TRFREQ_bm | DMA_CH_BURSTLEN_1BYTE_gc;  //Kana 0 dugo transferu 2 bajty, start manualny
	while(DMA.CH0.CTRLA & DMA_CH_ENABLE_bm);  //Zaczekaj na koniec transferu
	
	//Przesu elementy w src o jeden indeks w d
	DMA.CH0.ADDRCTRL=DMA_CH_SRCRELOAD_BLOCK_gc | DMA_CH_SRCDIR_INC_gc | DMA_CH_DESTDIR_INC_gc | DMA_CH_DESTRELOAD_BLOCK_gc;
	DMA.CH0.TRFCNT=sizeof(src)-sizeof(src[0]);                 //Blok ma dugo tablicy src -1 element
	DMA.CH0.SRCADDR0=(uint16_t)&src[1] & 0xFF;
	DMA.CH0.SRCADDR1=(uint16_t)&src[1] >>8;
	DMA.CH0.SRCADDR2=0;
	DMA.CH0.DESTADDR0=(uint16_t)&src[0] & 0xFF;
	DMA.CH0.DESTADDR1=(uint16_t)&src[0] >> 8;
	DMA.CH0.DESTADDR2=0;
	DMA.CH0.CTRLA=DMA_CH_ENABLE_bm | DMA_CH_TRFREQ_bm | DMA_CH_BURSTLEN_2BYTE_gc;  //Kana 0 dugo transferu 2 bajty, start manualny
	while(DMA.CH0.CTRLA & DMA_CH_ENABLE_bm);  //Zaczekaj na koniec transferu		
	
	//Wypenienie tablicy filltbl wartoci pierwszego elementu
	filltbl[0]=0xab;    //Ca tablic fill wypenimy wartoci elementu o indeksie 0
	DMA.CH0.ADDRCTRL=DMA_CH_SRCRELOAD_BLOCK_gc | DMA_CH_SRCDIR_INC_gc | DMA_CH_DESTDIR_INC_gc | DMA_CH_DESTRELOAD_BLOCK_gc;
	DMA.CH0.TRFCNT=sizeof(filltbl)-1;                 //Blok ma dugo tablicy fill -1 bajt
	DMA.CH0.SRCADDR0=(uint16_t)&filltbl[0] & 0xFF;
	DMA.CH0.SRCADDR1=(uint16_t)&filltbl[0] >>8;
	DMA.CH0.SRCADDR2=0;
	DMA.CH0.DESTADDR0=(uint16_t)&filltbl[1] & 0xFF;
	DMA.CH0.DESTADDR1=(uint16_t)&filltbl[1] >> 8;
	DMA.CH0.DESTADDR2=0;
	DMA.CH0.CTRLA=DMA_CH_ENABLE_bm | DMA_CH_TRFREQ_bm | DMA_CH_BURSTLEN_1BYTE_gc;  //Kana 0 dugo transferu 2 bajty, start manualny
	while(DMA.CH0.CTRLA & DMA_CH_ENABLE_bm);  //Zaczekaj na koniec transferu		
	
	//Wypenienie tablicy filltbl wzorcem dwubajtowym
	filltbl[0]=0xCC; filltbl[1]=0xDD;
	DMA.CH0.ADDRCTRL=DMA_CH_SRCRELOAD_BLOCK_gc | DMA_CH_SRCDIR_INC_gc | DMA_CH_DESTDIR_INC_gc | DMA_CH_DESTRELOAD_BLOCK_gc;
	DMA.CH0.TRFCNT=sizeof(filltbl)-2;                 //Blok ma dugo tablicy fill - 2 elementy
	DMA.CH0.SRCADDR0=(uint16_t)&filltbl[0] & 0xFF;
	DMA.CH0.SRCADDR1=(uint16_t)&filltbl[0] >>8;
	DMA.CH0.SRCADDR2=0;
	DMA.CH0.DESTADDR0=(uint16_t)&filltbl[2] & 0xFF;
	DMA.CH0.DESTADDR1=(uint16_t)&filltbl[2] >> 8;
	DMA.CH0.DESTADDR2=0;
	DMA.CH0.CTRLA=DMA_CH_ENABLE_bm | DMA_CH_TRFREQ_bm | DMA_CH_BURSTLEN_2BYTE_gc;  //Kana 0 dugo transferu 2 bajty, start manualny
	while(DMA.CH0.CTRLA & DMA_CH_ENABLE_bm);  //Zaczekaj na koniec transferu			
    
	//Wypenienie tablicy fill wzorcem czterobajtowym
	filltbl[0]=0xCC; filltbl[1]=0xDD; filltbl[2]=0xEE; filltbl[3]=0xFF;
	DMA.CH0.ADDRCTRL=DMA_CH_SRCRELOAD_BLOCK_gc | DMA_CH_SRCDIR_INC_gc | DMA_CH_DESTDIR_INC_gc | DMA_CH_DESTRELOAD_BLOCK_gc;
	DMA.CH0.TRFCNT=sizeof(filltbl)-4;                 //Blok ma dugo tablicy fill -1 element
	DMA.CH0.SRCADDR0=(uint16_t)&filltbl[0] & 0xFF;
	DMA.CH0.SRCADDR1=(uint16_t)&filltbl[0] >>8;
	DMA.CH0.SRCADDR2=0;
	DMA.CH0.DESTADDR0=(uint16_t)&filltbl[4] & 0xFF;
	DMA.CH0.DESTADDR1=(uint16_t)&filltbl[4] >> 8;
	DMA.CH0.DESTADDR2=0;
	DMA.CH0.CTRLA=DMA_CH_ENABLE_bm | DMA_CH_TRFREQ_bm | DMA_CH_BURSTLEN_4BYTE_gc;  //Kana 0 dugo transferu 2 bajty, start manualny
	while(DMA.CH0.CTRLA & DMA_CH_ENABLE_bm);  //Zaczekaj na koniec transferu		

	//Wypenienie tablicy fill wzorcem omiobajtowym
	filltbl[0]=0x01; filltbl[1]=0x02; filltbl[2]=0x03; filltbl[3]=0x05;
	filltbl[4]=0x11; filltbl[5]=0x22; filltbl[6]=0x33; filltbl[7]=0x44;
	DMA.CH0.ADDRCTRL=DMA_CH_SRCRELOAD_BLOCK_gc | DMA_CH_SRCDIR_INC_gc | DMA_CH_DESTDIR_INC_gc | DMA_CH_DESTRELOAD_BLOCK_gc;
	DMA.CH0.TRFCNT=sizeof(filltbl)-8;                 //Blok ma dugo tablicy fill -1 element
	DMA.CH0.SRCADDR0=(uint16_t)&filltbl[0] & 0xFF;
	DMA.CH0.SRCADDR1=(uint16_t)&filltbl[0] >>8;
	DMA.CH0.SRCADDR2=0;
	DMA.CH0.DESTADDR0=(uint16_t)&filltbl[8] & 0xFF;
	DMA.CH0.DESTADDR1=(uint16_t)&filltbl[8] >> 8;
	DMA.CH0.DESTADDR2=0;
	DMA.CH0.CTRLA=DMA_CH_ENABLE_bm | DMA_CH_TRFREQ_bm | DMA_CH_BURSTLEN_8BYTE_gc;  //Kana 0 dugo transferu 2 bajty, start manualny
	while(DMA.CH0.CTRLA & DMA_CH_ENABLE_bm);  //Zaczekaj na koniec transferu	

	while(1) {}
}