/*
 * DblBuffer.c
 *
 * Created: 2013-03-10 10:56:50
 *  Author: tmf
 */ 


#include <avr/io.h>

uint8_t Bufor[10];  //Miejsce na pierwszy bufor
uint8_t Rzedy[8];   //Miejsce na drugi bufor

void SPI_init()
{
	PORTC.DIRSET=PIN3_bm | PIN1_bm;   //Pin TxD i SCK jest wyjciem
	USARTC0.CTRLB=USART_TXEN_bm | USART_CLK2X_bm; //Odblokuj MOSI i tryb podwjnej szybkoci
	USARTC0.CTRLC=USART_CMODE_MSPI_gc; //Wybierz tryb SPI, MSB najpierw,
	USARTC0.BAUDCTRLA=0;
	USARTC0.BAUDCTRLB=0;    //SCK=F_CPU/2
}

void DMA_init()
{
	DMA.CH0.SRCADDR0=(uint16_t)Bufor & 0xff;
	DMA.CH0.SRCADDR1=((uint16_t)Bufor >> 8) & 0xff;
	DMA.CH0.SRCADDR2=0;
	DMA.CH0.DESTADDR0=((uint16_t)&USARTC0_DATA) & 0xff;
	DMA.CH0.DESTADDR1=((uint16_t)&USARTC0_DATA >> 8) & 0xff;
	DMA.CH0.DESTADDR2=0;
	DMA.CH0.ADDRCTRL=DMA_CH_SRCRELOAD_BLOCK_gc | DMA_CH_SRCDIR_INC_gc | DMA_CH_DESTRELOAD_BURST_gc | DMA_CH_DESTDIR_FIXED_gc;
	DMA.CH0.TRIGSRC=DMA_CH_TRIGSRC_USARTC0_DRE_gc; //Pusty bufor USART wyzwala zdarzenie
	DMA.CH0.REPCNT=0; //Nieskoczona liczba transferw
	DMA.CH0.TRFCNT=sizeof(Bufor); //Transferujemy jako blok wiersz bufora
	DMA.CH0.CTRLA=DMA_CH_ENABLE_bm | DMA_CH_SINGLE_bm | DMA_CH_REPEAT_bm | DMA_CH_BURSTLEN_1BYTE_gc;

	DMA.CH1.SRCADDR0=(uint16_t)Rzedy & 0xff;
	DMA.CH1.SRCADDR1=((uint16_t)Rzedy >> 8) & 0xff;
	DMA.CH1.SRCADDR2=0;
	DMA.CH1.DESTADDR0=((uint16_t)&USARTC0_DATA) & 0xff;
	DMA.CH1.DESTADDR1=((uint16_t)&USARTC0_DATA >> 8) & 0xff;
	DMA.CH1.DESTADDR2=0;
	DMA.CH1.ADDRCTRL=DMA_CH_SRCRELOAD_BLOCK_gc | DMA_CH_SRCDIR_INC_gc | DMA_CH_DESTRELOAD_BURST_gc | DMA_CH_DESTDIR_FIXED_gc;
	DMA.CH1.TRIGSRC=DMA_CH_TRIGSRC_USARTC0_DRE_gc; //Pusty bufor USART wyzwala zdarzenie
	DMA.CH1.REPCNT=0; //Nieskoczona liczba transferw
	DMA.CH1.TRFCNT=sizeof(Rzedy); //Transferujemy jako blok wiersz bufora
	DMA.CH1.CTRLA=DMA_CH_SINGLE_bm | DMA_CH_REPEAT_bm | DMA_CH_BURSTLEN_1BYTE_gc;

	DMA.CTRL=DMA_ENABLE_bm | DMA_DBUFMODE_CH01_gc; //Tryb double buffer dla kanaw 0 i 1
}

int main(void)
{
	SPI_init();
	DMA_init();
	while(1)
	{
		asm volatile ("nop");
	}
}