/*
 * stream.c
 *
 * Created: 2013-01-27 16:11:24
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <stdio.h>
#include <util/delay.h>
#include "usart.h"

int get(FILE *stream)
{
	while(!(USARTC0_STATUS & USART_RXCIF_bm));
	return USARTC0_DATA;
}

int put(char c, FILE *stream)
{
	while(!(USARTC0_STATUS & USART_DREIF_bm));
	USARTC0_DATA=c;
	return 0;
}

void USART_init()
{
	PORTC_OUTSET=PIN3_bm;
	PORTC_DIRSET=PIN3_bm;                          //Pin TxD musi by wyjciem
	USARTC0.CTRLB=USART_TXEN_bm | USART_RXEN_bm;   //W??cz nadajnik USART
	USARTC0.CTRLC=USART_CHSIZE_8BIT_gc;            //Ramka 8 bitw, bez parzystoci, 1 bit stopu
	usart_set_baudrate(&USARTC0, 9600, F_CPU);
}

int main(void)
{
	USART_init();
	
	static FILE usartout = FDEV_SETUP_STREAM (put, get, _FDEV_SETUP_RW);
	
    while(1)
    {
		fgetc(&usartout);  //Zaczekaj na klawisz
        fprintf(&usartout, "Oto strumien\r");
    }
}