/*
 * Matryca.c
 *
 * Created: 2013-03-07 21:18:35
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>
#include <string.h>

#define M_WITDTH   6         //Dugo wiersza matrycy w bajtach
#define M_HEIGHT   8         //Wysoko matrycy w wierszach
#define LED_REFRESHRATE 320  //Czstotliwo odwierzania matrycy

uint8_t Bufor[M_HEIGHT][M_WITDTH+1]={  //Miejsce na bufor i adres wiersza
                                     {0, 0, 0, 0, 0, 0, 0b11111110},
                                     {0, 0, 0, 0, 0, 0, 0b11111101},
                                     {0, 0, 0, 0, 0, 0, 0b11111011},
                                     {0, 0, 0, 0, 0, 0, 0b11110111},
                                     {0, 0, 0, 0, 0, 0, 0b11101111},
                                     {0, 0, 0, 0, 0, 0, 0b11011111},
                                     {0, 0, 0, 0, 0, 0, 0b10111111},
                                     {0, 0, 0, 0, 0, 0, 0b01111111}};

ISR(USARTC0_TXC_vect)
{
	PORTC_OUTTGL=PIN7_bm; //Generujemy impuls strobu zapisu do rejestru szeregowego
	PORTC_OUTTGL=PIN7_bm;
}

ISR(TCC0_OVF_vect)
{
	if(DMA.CH0.REPCNT==0)
	{
		DMA.CH0.REPCNT=M_HEIGHT; //Zakoczylimy skan wic zaczynamy od nowa
		DMA.CH0.SRCADDR0=(uint16_t)Bufor & 0xff;
		DMA.CH0.SRCADDR1=((uint16_t)Bufor >> 8) & 0xff;
		DMA.CH0.SRCADDR2=0;
	}		
	DMA.CH0.CTRLA|=DMA_CH_ENABLE_bm;  //Odblokuj transfer
}

void SPI_init()
{
	PORTC.DIRSET=PIN3_bm | PIN1_bm;      //Pin TxD i SCK jest wyjciem
	USARTC0.CTRLA=USART_TXCINTLVL_LO_gc; //Odblokuj przerwanie pustego bufora
	USARTC0.CTRLB=USART_TXEN_bm;         //Odblokuj MOSI i tryb podwjnej szybkoci
	USARTC0.CTRLC=USART_CMODE_MSPI_gc;   //Wybierz tryb SPI, MSB najpierw, 
	USARTC0.BAUDCTRLA=0;
	USARTC0.BAUDCTRLB=0;    //SCK=F_CPU/2
}

void DMA_init()
{
	DMA.CH0.SRCADDR0=(uint16_t)Bufor & 0xff;
	DMA.CH0.SRCADDR1=((uint16_t)Bufor >> 8) & 0xff;
	DMA.CH0.SRCADDR2=0;	
	DMA.CH0.DESTADDR0=((uint16_t)&USARTC0_DATA) & 0xff;
	DMA.CH0.DESTADDR1=((uint16_t)&USARTC0_DATA >> 8) & 0xff;
	DMA.CH0.DESTADDR2=0;
	DMA.CH0.ADDRCTRL=DMA_CH_SRCRELOAD_NONE_gc | DMA_CH_SRCDIR_INC_gc | DMA_CH_DESTRELOAD_BURST_gc | DMA_CH_DESTDIR_FIXED_gc;
	DMA.CH0.TRIGSRC=DMA_CH_TRIGSRC_USARTC0_DRE_gc; //Pusty bufor USART wyzwala zdarzenie
	DMA.CH0.REPCNT=M_HEIGHT;    //Transfer 8 wierszy
	DMA.CH0.TRFCNT=M_WITDTH+1;  //Transferujemy jako blok wiersz bufora
	DMA.CH0.CTRLA=DMA_CH_SINGLE_bm | DMA_CH_BURSTLEN_1BYTE_gc;

	DMA.CTRL=DMA_ENABLE_bm; //Odblokuj DMA
}

void Timer_init()
{
	TCC0.PER=F_CPU/(LED_REFRESHRATE*M_HEIGHT); //Ustaw czstotliwo odwieania wierszy
	TCC0.INTCTRLA=TC_OVFINTLVL_LO_gc;          //Wcz przerwanie nadmiaru - inicjacjitransferu wiersza
	TCC0.CTRLA=TC_CLKSEL_DIV1_gc;
}

void ASM_ROL(uint8_t cnt, uint8_t *buf)
{
__asm__ __volatile__
(
  "  clc"                   "\n\t"
  "__l1:"                   "\n\t"
  "  ld __tmp_reg__, %a0"   "\n\t"
  "  rol __tmp_reg__"       "\n\t"
  "  st %a0+, __tmp_reg__"  "\n\t"
  "  dec %1"                "\n\t"
  "  brne __l1"             "\n\t"
  : "=e" (buf), "=r" (cnt)
  : "0" (buf), "1" (cnt)
  : "r0");
}

int main(void)
{
	PORTC.DIRSET=PIN7_bm;                   //PC7 jest wyjciem na ktym jest sygna strobu zapisu zatrzasw
	PORTC.OUTCLR=PIN7_bm;
	DMA_init();
	SPI_init();
	Timer_init();
	
	PMIC_CTRL=PMIC_LOLVLEN_bm; //Odblokuj przerwania niskiego poziomu
	sei();

    uint8_t colno=0;
    uint8_t buf[M_WITDTH] = {0};
	buf[0]=1;
	while(1)
	{
		for(uint8_t p=0; p<8; p++) memcpy(&Bufor[p][0], buf, sizeof(buf));
		ASM_ROL(sizeof(buf), buf);
		colno++;
		if(colno==M_WITDTH*8)
		{
			colno=0;
			buf[0]=1;
		}
		_delay_ms(50);
	}
}