/*
 * _7LEDEnc.c
 *
 * Created: 2012-12-16 21:39:55
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/atomic.h>
#include <string.h>
#include <util/delay.h>
#include "LED7seg.h"

volatile uint16_t cnt;

void ConvToBuf(uint16_t num);
uint16_t ConvBufToInt();

void ENC_init()
{
	PORTCFG_MPCMASK=0b00000011;        //Zapisz now konfiguracj do pinw 0, 1 i 2
	PORTE_PIN0CTRL=PORT_ISC_LEVEL_gc | PORT_OPC_PULLUP_gc;  //Zdarzenia generuje niski poziom

	EVSYS_CH0MUX=EVSYS_CHMUX_PORTE_PIN0_gc; //PE0 bdzie rdem zdarze
	EVSYS_CH0CTRL=EVSYS_QDEN_bm | EVSYS_DIGFILT_2SAMPLES_gc;   //Odblokuj dekoder kwadraturowy dla CH0
	
	TCC1_CTRLD=TC_EVACT_QDEC_gc | TC_EVSEL_CH0_gc;  //Wcz event action jako QDEC z kanau CH0
	TCC1_CTRLA=TC_CLKSEL_DIV1_gc;     //TCC1 taktowany z CLKPER
}

uint8_t Buttons;     //Wcinity przycisk

ISR(TCD0_OVF_vect)
{
	static uint16_t prevcnt;
	enum StateType {ST_Nothing, ST_BtnRotate};
	static enum StateType State=ST_Nothing;
	
	uint8_t OldButtons=Buttons;    //Poprzedni stan przyciskw
	Buttons&=~PIN2_bm;             //Skasuj pozycj odpowiadajc pinowi
	Buttons|=(PORTE_IN & PIN2_bm); //Przepisz stan klawisza do zmiennej Buttons

	if((Buttons & PIN2_bm) && ((Buttons^OldButtons) & PIN2_bm))
	{
		if(State==ST_Nothing)
		{
			LEDBLINK^=LEDBLINKMARKER;
			prevcnt=TCC1_CNT;
		} else cnt=ConvBufToInt();  //Konwersja liczby z wywietlacza na posta binarn
		State=ST_Nothing;			
	}		
		
	if(LEDBLINK & LEDBLINKMARKER) return; //nie jestemy w trybie zmiany wartoci

	uint16_t cnt=TCC1_CNT;
	uint16_t tmp=cnt;
	int acnt=(cnt-prevcnt);
	acnt=acnt/4;              //Dzielimy przez 4 bo enkoder daje 4 zmiany stanu na przeskok
	if(acnt!=0)               //Czy od ostatniego razu zmienio si pooenie enkodera?
	{
		prevcnt=tmp;          //Zapisz aktualn warto licznika impuls enkodera
		if(Buttons & PIN2_bm)  //Zmieniamy pozycj, czy cyfr?
		{
			ATOMIC_BLOCK(ATOMIC_FORCEON)
			{
			LEDBLINK+=acnt;
			LEDBLINK%=LEDDISPNO;
			}
		} else
		{
			LEDDIGITS[LEDBLINK]=(LEDDIGITS[LEDBLINK]+acnt)%10;
			State=ST_BtnRotate;  //Zmienilimy cyfr
		}
	}		
}

void TCD0_init()
{
	TCD0.INTCTRLA=TC_OVFINTLVL_LO_gc;
	PMIC_CTRL|=PMIC_LOLVLEN_bm;
	TCD0.CTRLA=TC_CLKSEL_DIV1_gc;  //Preskaler timenra na 8, przerwanie 30 razy/s
}

void ConvToBuf(uint16_t num)
{
	char bufor[4];
	bufor[0]=num%10; num/=10;
	bufor[1]=num%10; num/=10;
	bufor[2]=num%10; num/=10;
	bufor[3]=num%10; num/=10;
	ATOMIC_BLOCK(ATOMIC_RESTORESTATE)
	{
		memcpy(LEDDIGITS, bufor, 4); //Skopiuj now zawarto bufora
	}		
}

uint16_t ConvBufToInt()
{
	char bufor[4];
	ATOMIC_BLOCK(ATOMIC_RESTORESTATE)
	{
		memcpy(bufor, LEDDIGITS, 4); //Skopiuj now zawarto do bufora
	}
	return bufor[3]*1000+bufor[2]*100+bufor[1]*10+bufor[0];
}

int main(void)
{
	ConvToBuf(cnt);

	ENC_init();
	TCD0_init();
	LED7Seg_init();
	LCD7Seg_SetIntensity(200);
	sei();
	
    while(1)
	{
		if(LEDBLINK & LEDBLINKMARKER)
		{
			ConvToBuf(cnt);
			if(cnt) --cnt;
			_delay_ms(10);
		}
	}
}