/*
 * FSMtablica.c
 *
 * Created: 2012-12-28 20:46:21
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <avr/interrupt.h>

void LED_init()
{
	PORTE.OUTSET=PIN0_bm;   //Dioda LED0 wyczona
	PORTE.DIRSET=PIN0_bm;
}

void LED_off()
{
	PORTE_OUTSET=PIN0_bm;     //Zga diod
}

void LED_on()
{
	PORTE_OUTCLR=PIN0_bm;     //Wcz diod
}


enum Events {Ev_SW0, Ev_SW1, Ev_SW2, Ev_SW3, Ev_END};   //Zdarzenia
enum States {St_Wait, St_SW1, St_SW2, St_LED, St_END};  //Stany automatu
	
typedef void (*StChgFunc)(enum Events Event);   //Typ funkcji przejcia
	
typedef struct  
{
	enum States State;     //Stan maszyny
	StChgFunc func;        //Funckja przejcia
} FSMTable_t;

void LEDOnAction(enum Events Event);
void Reset_Action(enum Events Event);

FSMTable_t TransTable[St_END][Ev_END] = {
	[St_Wait][Ev_SW1]={St_SW1, 0},
	[St_SW1][Ev_SW2]={St_SW2, 0},
	[St_SW2][Ev_SW3]={St_LED, LEDOnAction}
};

enum States CurrState=St_Wait;                  //Stan pocztkowy

void FSM_DispatchEvent(enum Events event)
{
	StChgFunc func=TransTable[CurrState][event].func;
	enum States tmpState=TransTable[CurrState][event].State;
	if(func) (*func)(event);
	if(tmpState==0)
	{
		tmpState=St_Wait;
		Reset_Action(St_Wait);
	}
	CurrState=tmpState;
}

void LEDOnAction(enum Events Event)
{
	LED_on();	
};

void Reset_Action(enum Events Event)
{
	LED_off();
	CurrState=St_Wait;	
};

ISR(TCC1_OVF_vect)
{
	static uint8_t Buttons;
	
	uint8_t OldButtons=Buttons;
	Buttons=PORTD_IN;

	OldButtons^=Buttons;
	if((OldButtons) && ((OldButtons & Buttons)==0))
	{
		enum Events ev;
		switch(OldButtons & 0x0F)
		{
			case 0b0001:  ev=Ev_SW0; break;
			case 0b0010:  ev=Ev_SW1; break;
			case 0b0100:  ev=Ev_SW2; break;
			case 0b1000:  ev=Ev_SW3; break;
		};
		
		FSM_DispatchEvent(ev);
	}
}

void Btn_init()
{
	PORTCFG_MPCMASK=PIN0_bm | PIN1_bm | PIN2_bm | PIN3_bm; //Klawisze SW0-SW3
	PORTD_PIN0CTRL=PORT_OPC_PULLUP_gc;  //Wczamy podciganie pod SW0-SW3

	TCC1.INTCTRLA=TC_OVFINTLVL_LO_gc;
	TCC1.PER=F_CPU/8/30;   //Okres timera - ok. 30 przerwa/sekund
	PMIC_CTRL|=PMIC_LOLVLEN_bm;

	TCC1.CTRLA=TC_CLKSEL_DIV8_gc;  //Preskaler timenra na 8
}


int main(void)
{
	LED_init();
	Btn_init();
	sei();
    while(1)
    {
        //TODO:: Please write your application code 
    }
}