/*
 * usart_MPCM.c
 *
 * Created: 2013-01-29 20:16:26
 *  Author: tmf
 */ 

#include <stdbool.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include "usart.h"

#define SLAVE_ADDRESS 0x10        //Adres urzdzenia slave

void USART_MPCM(bool en)
{
	if(en) USARTC0_CTRLB|=USART_MPCM_bm;
	 else USARTC0_CTRLB&=~USART_MPCM_bm;
}

ISR(USARTC0_RXC_vect)
{
	uint8_t ch=USARTC0_DATA;
    USART_send_F(&USARTC0, PSTR("Odebrano ramke adresu\r"));
	if(ch==SLAVE_ADDRESS)
	{
		USART_MPCM(false);
	//Tu powinnimy wyczy tryb MPCM i odebra dane
	}	
}

void USART_slave_init()
{
	PORTC_OUTSET=PIN3_bm;
	PORTC_DIRSET=PIN3_bm;                          //Pin TxD musi by wyjciem
	USARTC0.CTRLA=USART_RXCINTLVL_LO_gc;           //Odblokuj przerwania odbiornika
	PMIC_CTRL|=PMIC_LOLVLEN_bm;                    //Odblokuj przerwanie niskiego poziomu
	USARTC0.CTRLB=USART_TXEN_bm | USART_RXEN_bm;   //Wcz nadajnik USART
	USARTC0.CTRLC=USART_CHSIZE_9BIT_gc;            //Ramka 9 bitw, bez parzystoci, 1 bit stopu
	USART_MPCM(true);                              //Wcz tryb MPCM
	usart_set_baudrate(&USARTC0, 9600, F_CPU);     //Szybko transmisji
}

int main(void)
{
	USART_slave_init();
	sei();
    while(1)
    {
        //TODO:: Please write your application code 
    }
}