/*
 * _16bitRTCp3.c
 *
 * Created: 2012-03-03 09:20:54
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <avr/interrupt.h>

volatile uint32_t timestamp;

ISR(RTC_OVF_vect)                     //Przerwanie przepenienia licznika
{
	timestamp++;                      //Zwiksz licznik sekund
}

static inline void wait_for_RTC_sync()
{
	while(RTC.STATUS & RTC_SYNCBUSY_bm);     //Czekaj a flaga SYNCBUSY si wyzeruje
}

int main(void)
{
	OSC_XOSCCTRL=OSC_XOSCSEL_32KHz_gc;	//Wybierz kwarc zegarkowy
	OSC_CTRL|=OSC_XOSCEN_bm;            //Odblokuj oscylator
	
	CLK_RTCCTRL=CLK_RTCSRC_TOSC32_gc;    //Zewntrzny kwarc 32768 Hz
	CLK_RTCCTRL|=CLK_RTCEN_bm;           //Wcz wybrany oscylator dla RTC

	RTC.PER=32768;                       //W cigu sekundy mamy 32768 okresw zegara
	RTC.CNT=0;
	wait_for_RTC_sync();                 //Poczekaj na synchronizacj rejestrw CNT i PER
	
	RTC.INTCTRL=RTC_OVFINTLVL_LO_gc;     //Wcz przerwania przepenienia, nadajc im niski priorytet
	wait_for_RTC_sync(); 
	PMIC_CTRL=PMIC_LOLVLEN_bm;           //Odblokuj przerwania niskiego poziomu
	
	RTC.CTRL=RTC_PRESCALER_DIV1_gc;      //Preskaler 1 - brak podziau
	
	sei();    
	while(1)
    {
        //TODO:: Please write your application code 
    }
}