/*
 * LCD.c
 *
 * Created: 2012-01-30 20:55:42
 *  Author: tmf
 */ 

#include <avr\pgmspace.h>
#include "LCD.h"
#include "defines.h"
#include "hd44780.h"

//Prywatne zmienne moduu
static bool second_nl_seen;   
static uint8_t line;       //Nr wywietlanej linii na LCD

void lcd_init()
{

  hd44780_init();				//Podstawowa inicjalizacja moduu
  hd44780_outcmd(HD44780_CLR);	//Wyczy pami DDRAM
  hd44780_wait_ready(1000);
  hd44780_outcmd(HD44780_ENTMODE(1, 0));	//Tryb autoinkrementacji AC
  hd44780_wait_ready(1000);
  hd44780_outcmd(HD44780_DISPCTL(1, 0, 0));	//Wcz wywietlacz, wycz kursor
  hd44780_wait_ready(1000);
} 

void lcd_putchar(char c)
{
  if ((second_nl_seen) && (c != '\n')&&(line==0))
  {//Odebrano pierwszy znak
      hd44780_wait_ready(40);
      hd44780_outcmd(HD44780_CLR);
      hd44780_wait_ready(1600);
      second_nl_seen=false;   
  }
  if (c == '\n')
  {
        if (line==0)
   {
           line++;
           hd44780_outcmd(HD44780_DDADDR(64));	//Adres pierwszego znaku drugiej linii
           hd44780_wait_ready(1000);   
   }
   else
   {
        second_nl_seen=true;
        line=0;
   }
  }
  else
  {     
     hd44780_outdata(c);
     hd44780_wait_ready(40);
  }
} 

void lcd_puttext(char *txt)
{
	char ch;
	while((ch=*txt))
	{
		lcd_putchar(ch);
		txt++;
	}
}

void lcd_puttext_P(const char *txt)
{
	char ch;
	while((ch=pgm_read_byte(txt)))
	{
		lcd_putchar(ch);
		txt++;
	}
}

void lcd_clr()
{
	hd44780_outcmd(HD44780_CLR);
	line=0;
	second_nl_seen=false;
	hd44780_wait_ready(1000);
}

void lcd_home()
{
	hd44780_outcmd(HD44780_HOME);
	line=0;
	second_nl_seen=false;
	hd44780_wait_ready(1000);
}
