/*
 * LED7Seg.c
 *
 * Created: 2012-12-08 12:31:44
 *  Author: tmf
 */ 

#include <avr\io.h>
#include <avr\pgmspace.h>
#include <util\delay.h>
#include <avr\interrupt.h>
#include "LED7seg.h"

//Cyfry 0,1,2,3,4,5,6,7,8,9 i symbol -
static const uint8_t PROGMEM DIGITS[]={0xC0, 0xF9, 0xA4, 0xB0, 0x99, 0x92, 0x82, 0xF8, 0x80, 0x90, 0xBF, 0x00};
const uint8_t DP=0x80;

uint8_t LEDDIGITS[LEDDISPNO];  //Bufor na wywietlane cyfry
volatile uint8_t LEDBLINK;     //Wskanik migajcej pozycji

static inline void ShowOnLED(uint8_t val)
{
	uint8_t tmp=0xFF;
	if((val & 0x7F)<11) tmp=pgm_read_byte(&DIGITS[val & 0x7F]);
	if((val & DP)==1) tmp&=~(DP);
	PORTC_OUT=tmp;
}

//Przerwanie zmienia aktualnie wywietlan cyfr
ISR(TCC0_OVF_vect)
{
	static uint8_t LEDNO;  //Aktualnie wywietlana cyfra
	static uint16_t INTNo; //Numer przerwania
	static uint8_t OnOff;  //Wczy cyfr czy nie

	PORTB_OUTSET=0x0F;		//Wycz wszystkie wywietlacze
	LEDNO=(LEDNO+1) % LEDDISPNO; //Kolejna cyfra do wywietlenia
	INTNo++;
	if((INTNo % LEDBLINKPERIOD)==0) OnOff^=1;
	if((OnOff==0) && (LEDNO==LEDBLINK)) PORTB_OUTSET=0x0f; //Wycz wywietlacz
	   else
	   {
		   ShowOnLED(LEDDIGITS[LEDNO]);
	       PORTB_OUTCLR=(1<<LEDNO);	//Wybierz kolejny wywietlacz
	   }	
}

//Przerwanie wycza wywietlan cyfr - regulacja jasnoci
ISR(TCC0_CCA_vect)
{
	PORTB_OUTSET=0x0f; //Wycz wszystkie wywietlacze
}

//Inicjalizacja biblioteki
void LED7Seg_init()
{
	PORTC_DIR=0xFF;   //Port sterujcy segmentami
	PORTB_DIR=0x0F;   //Port sterujcy wsplnymi elektrodami
	
	TCC0.CTRLB=TC0_CCAEN_bm; //Odblokuj compare A
	TCC0.INTCTRLA=TC_OVFINTLVL_MED_gc;
	TCC0.INTCTRLB=TC_CCAINTLVL_MED_gc;
	TCC0.PER=0x00ff;   //Okres timera
	LCD7Seg_SetIntensity(128);
	PMIC_CTRL|=PMIC_MEDLVLEN_bm;
	
	TCC0.CTRLA=TC_CLKSEL_DIV8_gc;  //Preskaler timenra na 8
}
