/*
 * Buttons.c
 *
 * Created: 2012-12-27 10:06:06
 *  Author: tmf
 */ 

#include "Buttons.h"
#include <avr/io.h>
#include <avr/interrupt.h>
#include "FSM.h"

ISR(TCC1_OVF_vect)
{
	static uint8_t Buttons;
	
	uint8_t OldButtons=Buttons;
	if(PORTE_IN & PIN5_bm) Buttons|=1; else Buttons&=0xfe;
	if(PORTF_IN & PIN1_bm) Buttons|=2; else Buttons&=0xfd;
	if(PORTF_IN & PIN2_bm) Buttons|=4; else Buttons&=0xfb;
	
	OldButtons^=Buttons;
	if(OldButtons)
	{
		if(((Buttons & 1)==0) && (OldButtons & 1)) FSM_DispatchEvent(Action_Btn1Pressed);
		if(((Buttons & 2)==0) && (OldButtons & 2)) FSM_DispatchEvent(Action_Btn2Pressed);
		if(((Buttons & 4)==0) && (OldButtons & 4)) FSM_DispatchEvent(Action_Btn3Pressed);
	}
}

void BTN_init()
{
	PORTE_PIN5CTRL=PORT_OPC_PULLUP_gc; //BTN 1 na pytce
	PORTE_DIRCLR=PIN5_bm;
	PORTCFG_MPCMASK=PIN1_bm | PIN2_bm; //BTN 2 i 3
	PORTF_PIN1CTRL=PORT_OPC_PULLUP_gc;
	PORTF_DIRCLR=PIN1_bm | PIN2_bm;
	
	TCC1.INTCTRLA=TC_OVFINTLVL_LO_gc;
	TCC1.PER=F_CPU/8/30;   //Okres timera - ok. 30 przerwa/sekund
	PMIC_CTRL|=PMIC_LOLVLEN_bm;

	TCC1.CTRLA=TC_CLKSEL_DIV8_gc;  //Preskaler timenra na 8
}