/*
 * Stack.c
 *
 * Created: 2012-09-10 20:21:22
 *  Author: tmf
 */ 

#include <stdint.h>

#define STACK_MAXELEMENTS   15 //Maksymalna liczba elementw na stosie
typedef uint8_t Stack_element; //Co odkadamy na stosie
typedef struct
{
	Stack_element Stack[STACK_MAXELEMENTS];   //Miejsce na stos 
	int top;                   //Wskanik stosu
} Stack;

void stack_push(Stack *S, Stack_element val);
Stack_element stack_pop(Stack *S);
void stack_init(Stack *S);
int stack_isfull(Stack *S);

void stack_push(Stack *S, Stack_element val)
{
	S->Stack[S->top ]=val;
	(S->top)++;            //Zwiksz wskanik stosu
}

Stack_element stack_pop(Stack *S)
{
	(S->top)--;            //Zmniejsz wskanik stosu
	return (S->Stack[S->top]); //Zwr ostatni element
}

void stack_init(Stack *S)
{
	S->top = 0;
}

int stack_isfull(Stack *S)
{
	return (S->top >= STACK_MAXELEMENTS);
}

Stack Stos;

int main(void)
{
	stack_init(&Stos);      //Waciwie niepotrzebne, gdy zmienne globalne s automatycznie zerowane
	stack_push(&Stos, 1);
	stack_push(&Stos, 2);
	stack_push(&Stos, 3);
	stack_push(&Stos, 4);
	volatile static uint8_t val;
	val=stack_pop(&Stos);
	val=stack_pop(&Stos);
	val=stack_pop(&Stos);
	val=stack_pop(&Stos);
    while(1)
    {
        //TODO:: Please write your application code 
    }
}