/*
 * QDEC.c
 *
 * Created: 2012-04-12 21:25:09
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <stdlib.h>
#include "LCD.h"

int main(void)
{
	char bufor[6];                     //Bufor na liczb
	int16_t cnt;
	
	PORTCFG_MPCMASK=0b00000111;                                 //Zapisz now konfiguracj do pinw 0 i 1
	PORTC_PIN0CTRL=PORT_ISC_LEVEL_gc | PORT_OPC_PULLUP_gc;      //Zdarzenia generuje niski poziom
	PORTC_PIN2CTRL=PORT_ISC_BOTHEDGES_gc | PORT_OPC_PULLUP_gc;  //Wejcie indeksu - zdarzenia dla obu zboczy

	EVSYS_CH0MUX=EVSYS_CHMUX_PORTC_PIN0_gc;                                    //PC0 bdzie rdem zdarze
	EVSYS_CH0CTRL=EVSYS_QDEN_bm | EVSYS_QDIEN_bm | EVSYS_DIGFILT_2SAMPLES_gc;   //Odblokuj dekoder kwadraturowy dla CH0, odblokuj indeks
	EVSYS_CH0CTRL|=EVSYS_QDIRM_00_gc;                       //Okrel stan wej A i B dla aktywnego indeksu
	EVSYS_CH1MUX=EVSYS_CHMUX_PORTC_PIN2_gc;
	
	TCC0_CTRLA=TC_CLKSEL_DIV1_gc;                   //TCC0 taktowany z CLKPER
	TCC0_CTRLD=TC_EVACT_QDEC_gc | TC_EVSEL_CH0_gc;  //Wcz event action jako QDEC z kanau CH0
	
	lcd_init();
	
    while(1)
    {
		if(TCC0_CNT!=cnt)
		{
			cnt=TCC0_CNT;
            itoa(cnt/4, bufor, 10);           //Konwersja wartoci CNT na tekst
			lcd_cls();                        //Skasuj lcd
		    lcd_puttext(bufor);               //Wywietl warto na LCD
		}			
    }
}